<?php
/** A simple text block **/
class AQ_Google_Map_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Google Map',
			'size' => 'span6',
		);
		
		//create the block
		parent::__construct('aq_google_map_block', $block_options);
	}
	
	function form($instance) {
		
		$defaults = array(
			'text' => '',
		);
		
		$map_options_select = array(
			'ROADMAP' => 'Vue carte routière',
			'SATELLITE' => 'Vue carte satélite',
			'HYBRID' => 'Vue carte routière + satélite',
			'TERRAIN' => 'Vue carte relief',
			
		);
		
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		$block_color = isset($block_color) ? $block_color : '#FFFFFF';
		$txt_block_color = isset($txt_block_color) ? $txt_block_color : '#000000';
		?>
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				Titre <em>(optionnel)</em>
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('map_adress') ?>">
				Adresse
                (Exemple : 15 Avenue des Champs-Élysées, 75008 Paris, France )
				<?php echo aq_field_textarea('map_adress', $block_id, $map_adress, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('map_select') ?>">
				Choisissez un type de carte.<br/>
				<?php echo aq_field_select('map_select', $block_id, $map_options_select, $map_select, $block_id); ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('title_block_color') ?>">
				Couleur de fond du bloc
				<?php echo aq_field_color_picker('block_color', $block_id, $block_color, $defaults['block_color']) ?>
			</label>
            <label for="<?php echo $this->get_field_id('title_block_color') ?>">
				Couleur du texte
				<?php echo aq_field_color_picker('txt_block_color', $block_id, $txt_block_color, $defaults['txt_block_color']) ?>
			</label>
		</p>
		<p>
        <label for="<?php echo $this->get_field_id('upload_images_txt') ?>">
         Texte du contenu de l'infobulle <em>(optionnel)</em>
		<?php echo aq_field_upload('txt_icon', $block_id, $txt_icon, $media_type = 'image');?>
        <img class="upload_images_txt" src="<?php echo $txt_icon ; ?>" border="0"/>
        </label>
        </p>
        <label for="<?php echo $this->get_field_id('txt_marker') ?>">
				Texte dans l'info bulle du marqueur 
				<?php echo aq_field_input('txt_marker', $block_id, $txt_marker, $size = 'full') ?>
			</label>
		<p class="description">
            <label for="<?php echo $this->get_field_id('height_map') ?>">
				Hauteur de la carte 
				<?php echo aq_field_input('height_map', $block_id, $height_map, $size = 'min') ?>px
			</label>
            
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
echo '<div class="contrainer-map">';
echo '<h2 class="title-video"><span>'.$title.'</span></h2>';		
echo '<div id="map" style="width:100%;height:'.$height_map.'px;"></div>';
echo '<script type="text/javascript">
   $(function() {
    $("#map").googleMap({	
	type: "'.$map_select.'", 
	});
    $("#map").addMarker({
    	address: "'.$map_adress.'",
		icon: "'.$txt_icon.'",
		title: "'.$txt_marker.'",
    	
    });
  })
</script>';

echo '</div>';
	}
	
}