<?php
/** A simple text block **/
class AQ_Text_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Text image',
			'size' => 'span6',
		);
		
		//create the block
		parent::__construct('aq_text_block', $block_options);
	}
	
	function form($instance) {
		
		$defaults = array(
			'text' => '',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		$block_color = isset($block_color) ? $block_color : '#FFFFFF';
		$txt_block_color = isset($txt_block_color) ? $txt_block_color : '#000000';
		?>
		<p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				Titre 
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('title_block_color') ?>">
				Couleur de fond du bloc
				<?php echo aq_field_color_picker('block_color', $block_id, $block_color, $defaults['block_color']) ?>
			</label>
            <label for="<?php echo $this->get_field_id('title_block_color') ?>">
				Couleur du texte
				<?php echo aq_field_color_picker('txt_block_color', $block_id, $txt_block_color, $defaults['txt_block_color']) ?>
			</label>
		</p>
		<p>
		<?php echo aq_field_upload('txt_icon', $block_id, $txt_icon, $media_type = 'image');?>
        <img class="upload_images_txt" src="<?php echo $txt_icon ; ?>" border="0"/>
        
        </p>
        
		<p class="description">
			<label for="<?php echo $this->get_field_id('text') ?>">
				Contenu
				<?php echo aq_field_textarea('text', $block_id, $text, $size = 'full') ?>
			</label>
           
           <label for="<?php echo $this->get_field_id('txt_link') ?>">
				 Intitulé du lien
				<?php echo aq_field_input('txt_link', $block_id, $txt_link, $size = 'full') ?>
			</label>
           
          <label for="<?php echo $this->get_field_id('page_links') ?>">
            Lien vers une page
         <?php wp_dropdown_pages( array(show_option_none=> 'Choisissez une page','id' => $this->get_field_id('page_links'),'name' => $this->get_field_name("page_links"), 'selected' => $instance["page_links"] ) ); ?>
            </label>
           <label for="<?php echo $this->get_field_id('custom_link') ?>">
				Lien personnalisé
				<?php echo aq_field_input('custom_link', $block_id, $custom_link, $size = 'full') ?>
			</label>
            <label for="<?php echo $this->get_field_id('target_link') ?>">
            
            <?php echo aq_field_checkbox('target_link', $block_id, $target_link, $check);?>
            Ouvrir le lien dans une nouvelle fenêtre/onglet
            </label>
		</p>
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		echo '<div class="row section_featured_texts">';
		echo '<div class="column one-third" id="section_featured_texts" style="background:'.$block_color.'; color: '.$txt_block_color.';">';
		echo '<span class="icon"><img src="'.$txt_icon.'" border="0"/></span>';
		
		// checkbox value
		if( $page_links ) {
		echo '<a href="'.get_permalink( $page_links ).'"><h3 style="color: '.$txt_block_color.';">'.strip_tags($title).'</h3></a>';
		} else {
			echo '<h3 style="color: '.$txt_block_color.';">'.strip_tags($title).'</h3>';
			};
		if( $custom_link ) {
		echo '<a href="'.$custom_link.'" '.$target_link_if.'><h3 style="color: '.$txt_block_color.';">'.strip_tags($title).'</h3></a>';
		} else {
			};
		
		 
		echo '<p>';
		echo wpautop(do_shortcode(htmlspecialchars_decode($text)));		
		echo '</p>';
		// checkbox value
		if(!empty($target_link)){
		$target_link_if = 'target="_blank"';}
		else
		{
		$target_link_if = 'target="_self"';
		}
		
		echo'</div>';
		echo'</div>';
	}
	
}