<?php
/**
 * @package WordPress
 * @subpackage Default_Theme
 */
// post nesws
require_once dirname( __FILE__ ) . '/functions/custom_post.php';
require_once dirname( __FILE__ ) . '/functions/membre/redirect/user.php';
// Widget
require_once dirname( __FILE__ ) . '/inc/post-type/news.php';
require_once dirname( __FILE__ ) . '/inc/newsticker.php';
require_once dirname( __FILE__ ) . '/inc/baner.php';
require_once dirname( __FILE__ ) . '/admin/admin.php';
// Widget
require_once dirname( __FILE__ ) . '/inc/widget/menu-vertical.php';
require_once dirname( __FILE__ ) . '/inc/widget/menu-accordion.php';
require_once dirname( __FILE__ ) . '/inc/widget/social-profil.php';
require_once dirname( __FILE__ ) . '/inc/widget/categorie_post.php';
require_once dirname( __FILE__ ) . '/inc/widget/profil.php';
require_once dirname( __FILE__ ) . '/inc/widget/category_widget.php';
require_once dirname( __FILE__ ) . '/inc/widget/facebook.php';
//Shortcodes
require_once dirname( __FILE__ ) . '/inc/shortcodes/youtube.php';
require_once dirname( __FILE__ ) . '/inc/shortcodes/shortcode.php';
require_once dirname( __FILE__ ) . '/inc/shortcodes/vimeo.php';
require_once dirname( __FILE__ ) . '/inc/shortcodes/toggle.php';
require_once dirname( __FILE__ ) . '/inc/shortcodes/column-shortcodes/column-shortcodes.php';
// customize live
require_once dirname( __FILE__ ) . '/admin/customize.php';
// Update value css design
require_once dirname( __FILE__ ) . '/admin/css_value.php';
// Image a le une
add_theme_support( 'post-thumbnails' );
// post formats
add_theme_support( 'post-formats', array( 'aside', 'gallery','video','audio','quote','link','status' ) );
// Rss
add_theme_support( 'automatic-feed-links' );
//CSS editeur
add_editor_style( 'css/editor-style.css' );
// Sidebar
if ( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widgettitle">',
		'after_title' => '</h3>',
	));
}

register_sidebar( array(
		'name' => __( 'Footer Première colonne'),
		'id' => 'sidebar-3',
		'description' => __( 'Zone de widgets footer'),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array(
		'name' => __( 'Footer Deuxième colonne'),
		'id' => 'sidebar-4',
		'description' => __( 'Zone de widgets footer'),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array(
		'name' => __( 'Footer Troisème colonne'),
		'id' => 'sidebar-5',
		'description' => __( 'Zone de widgets footer' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer Quatrième colonne'),
		'id' => 'sidebar-6',
		'description' => __( 'Zone de widgets footer' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => "</aside>",
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	
add_action('after_setup_theme', 'naxialis_theme_setup');
function naxialis_theme_setup(){
    load_theme_textdomain('naxialis-themes', get_template_directory() . '/languages');
}

// Search form Html5
function html5_search_form( $form ) {
    $form = '<form role="search" method="get" id="searchform" action="' . home_url( '/' ) . '" >
    <input type="search" class="search-form" type="search" placeholder="'.__("Rechercher...").'" value="' . get_search_query() . '" name="s" id="s" />
    </form>';

    return $form;
}
add_filter( 'get_search_form', 'html5_search_form' );


	

// Fonction register_nav_menus()
function add_wp3menu_support() {
 
register_nav_menus(
        array(
        'main-menu' => __('Menu Horizontal Jquery')
        
        )
     );
 
}
add_action('init', 'add_wp3menu_support');

// fonction image

function sp_resize( $url, $width, $height = null, $crop = null, $single = true ) {

	//validate inputs
	if(!$url OR !$width ) return false;

	//define upload path & dir
	$upload_info = wp_upload_dir();
	$upload_dir = $upload_info['basedir'];
	$upload_url = $upload_info['baseurl'];

	//check if $img_url is local
	if(strpos( $url, $upload_url ) === false) return false;

	//define path of image
	$rel_path = str_replace( $upload_url, '', $url);
	$img_path = $upload_dir . $rel_path;

	//check if img path exists, and is an image indeed
	if( !file_exists($img_path) OR !getimagesize($img_path) ) return false;

	//get image info
	$info = pathinfo($img_path);
	$ext = $info['extension'];
	list($orig_w,$orig_h) = getimagesize($img_path);

	//get image size after cropping
	$dims = image_resize_dimensions($orig_w, $orig_h, $width, $height, $crop);
	$dst_w = $dims[4];
	$dst_h = $dims[5];

	//use this to check if cropped image already exists, so we can return that instead
	$suffix = "{$dst_w}x{$dst_h}";
	$dst_rel_path = str_replace( '.'.$ext, '', $rel_path);
	$destfilename = "{$upload_dir}{$dst_rel_path}-{$suffix}.{$ext}";

	//if orig size is smaller
	if($width >= $orig_w) {

		if(!$dst_h) :
			//can't resize, so return original url
			$img_url = $url;
			$dst_w = $orig_w;
			$dst_h = $orig_h;

		else :
			//else check if cache exists
			if(file_exists($destfilename) && getimagesize($destfilename)) {
				$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
			} 
			//else resize and return the new resized image url
			else {
				$resized_img_path = image_resize( $img_path, $width, $height, $crop );
				$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
				$img_url = $upload_url . $resized_rel_path;
			}

		endif;

	}
	//else check if cache exists
	elseif(file_exists($destfilename) && getimagesize($destfilename)) {
		$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
	} 
	//else, we resize the image and return the new resized image url
	else {
		$resized_img_path = image_resize( $img_path, $width, $height, $crop );
		$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
		$img_url = $upload_url . $resized_rel_path;
	}

	//return the output
	if($single) {
		//str return
		$image = $img_url;
	} else {
		//array return
		$image = array (
			0 => $img_url,
			1 => $dst_w,
			2 => $dst_h
		);
	}

	return $image;
}
// fonction extrait
function excerpt($limit) {
      $excerpt = explode(' ', get_the_excerpt(), $limit);
      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
      $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
      return $excerpt;
    }


/**
 * Add Copyright text to general settings menu
 */
$custom_general_settings = new FD_Custom_General_Settings();
class FD_Custom_General_Settings
{
    function __construct()
    {
        add_filter('admin_init', array(&$this , 'register_fields'));
    }
    function register_fields()
    {
        register_setting('general', 'footer_text', 'esc_attr');
        add_settings_field('footer_text', '<label for="footer_text">'.__('Footer Text' , 'footer_text' ).'</label>' , array(&$this, 'fields_html') , 'general');
    }
    function fields_html()
    {
        $value = html_entity_decode(get_option('footer_text', ''));
        wp_editor($value, 'footer_text', array('textarea_rows'=>4), false);
    }
}
/* ------------------------------------------------------------------*/
/* ADD PRETTYPHOTO REL ATTRIBUTE FOR LIGHTBOX */
/* ------------------------------------------------------------------*/
 
add_filter('wp_get_attachment_link', 'rc_add_rel_attribute');
function rc_add_rel_attribute($link) {
	global $post;
	return str_replace('<a href', '<a class="lightbox" rel="group1" href', $link);
}


add_action('admin_head', 'my_custom_fonts');

function my_custom_fonts() {
  echo "<style>
    #widget-list [id*='nax-widget'] .widget-top {
		background: #0074A2;
		color:#fff;
    }
	#widget-list [id*='nax-social-widget'] .widget-top {
		background: #0074A2;
		color:#fff;
    } 
	#widget-list [id*='nax_facebook'] .widget-top {
		background: #0074A2;
		color:#fff;
    }   
  </style>";
}


/** Script Queue Share */
if (!is_admin()) add_action("wp_enqueue_scripts", "my_script_enqueue", 11);
function my_script_enqueue() {
   wp_deregister_script('jquery');
   wp_register_script('sharrre', get_stylesheet_directory_uri() . '/inc/share/jquery.sharrre.min.js');
   //wp_register_script('jquery', "http" . ($_SERVER['SERVER_PORT'] == 443 ? "s" : "") . "://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js", false, null);
   //wp_enqueue_script('jquery');
   wp_enqueue_script('sharrre', get_stylesheet_directory_uri() . '/inc/share/jquery.sharrre.min.js', array( 'jquery' ));
}

/** Share Button Stylesheet */
add_action( 'wp_enqueue_scripts', 'additional_styles' );
function additional_styles() {
	wp_register_style( 'share-css', get_stylesheet_directory_uri(). '/inc/share/share.css' );
	wp_register_style( 'genericons', get_stylesheet_directory_uri(). '/inc/share/genericons/genericons.css' );
	wp_enqueue_style( 'share-css' );
	wp_enqueue_style( 'genericons' );
}

/** Share Button Markup */
function ds_social_media_buttons() {
		ob_start(); // turn on output buffering
		include(get_stylesheet_directory() . '/inc/share/share.php');
		$share_hook = ob_get_contents(); // get the contents of the output buffer
		ob_end_clean(); //  clean (erase) the output buffer and turn off output buffering
		echo $share_hook;
}

// Login

function ajax_login_init(){

    wp_register_script('ajax-login-script', get_template_directory_uri() . '/js/ajax-login-script.js' ); 
    wp_enqueue_script('ajax-login-script');

    wp_localize_script( 'ajax-login-script', 'ajax_login_object', array( 
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'redirecturl' => home_url(),
        'loadingmessage' => __("Envoi d'informations de l'utilisateur, patienter ...")
    ));

    // Enable the user with no privileges to run ajax_login() in AJAX
    add_action( 'wp_ajax_nopriv_ajaxlogin', 'ajax_login' );
}

// Execute the action only if the user isn't logged in
if (!is_user_logged_in()) {
    add_action('init', 'ajax_login_init');
}


function ajax_login(){

    // First check the nonce, if it fails the function will break
    check_ajax_referer( 'ajax-login-nonce', 'security' );

    // Nonce is checked, get the POST data and sign user on
    $info = array();
    $info['user_login'] = $_POST['username'];
    $info['user_password'] = $_POST['password'];
    $info['remember'] = true;

    $user_signon = wp_signon( $info, false );
    if ( is_wp_error($user_signon) ){
        echo json_encode(array('loggedin'=>false, 'message'=>__("Nom d'utilisateur ou mot de passe incorrect.")));
    } else {
        echo json_encode(array('loggedin'=>true, 'message'=>__('Connexion réussie ....')));
    }

    die();
}

// pignation
function naxialis_pagination($pages = '', $range = 1)
{  
     $showitems = ($range * 4)-1;  

     global $paged;
     if(empty($paged)) $paged = 1;

     if($pages == '')
     {
         global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }   

     if(1 != $pages)
     {
         echo "<div class='pagination-pages'>";
         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'><i class='fa fa-angle-double-left'></i></a>";
         if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'><i class='fa fa-angle-left'></i></a>";

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
             }
         }

         if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'><i class='fa fa-angle-right'></i></a>";  
         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'><i class='fa fa-angle-double-right'></i></a>";
         echo "</div>\n";
     }
}

// pignation fin
// Ajout d'un nouveau rôle "Premium"
$result = add_role('Premium_role', 'Abonnement Premium', array(
    'read' => true, // True allows that capability
    'edit_posts' => true,
    'delete_posts' => false, // Use false to explicitly deny
));


remove_role( 'contributor' );

function modify_capabilities() {
	$editor_role = get_role('editor');
	add_role('owner', 'Verificateur', $editor_role->capabilities);
	$owner_role = get_role('owner');
	$owner_role->add_cap('edit_others_posts');
	$owner_role->add_cap('edit_posts');
	$owner_role->add_cap('edit_others_pages');
	
	$owner_role->remove_cap('delete_others_posts');
	$owner_role->remove_cap('upload_files');
	$owner_role->remove_cap('manage_categories');
	$owner_role->remove_cap('manage_links');
	$owner_role->remove_cap('delete_others_pages');
	
}
add_action('init','modify_capabilities');

//add_action( 'init', 'blockusers_init' );
function blockusers_init() {
if ( is_admin() && ! current_user_can( 'administrator' ) &&
! ( defined( 'DOING_AJAX' ) && DOING_AJAX ) ) {
wp_redirect( home_url() );
exit;
}
}


// Login logo

function my_login_logo() { ?>
    <style type="text/css">
        #login h1 a, .login h1 a {
            background-image: url(<?php echo get_stylesheet_directory_uri(); ?>/images/laprevention.png);
            padding-bottom: 0px;
			background-size: 320px 80px;
			width:320px;
        }
		#nav {
			display:none;
		}
    </style>
<?php }
add_action( 'login_enqueue_scripts', 'my_login_logo' );

// Shortcode premium 
include (TEMPLATEPATH .'/functions/membre/extra_admin.php');

// shortcode access Membre
add_shortcode( 'premium', 'member_premium_shortcode' );
function member_premium_shortcode( $atts, $content = null ) {

if ( is_user_logged_in() ) {
    
	global $current_user;
if (($current_user->roles[0] == "Premium_role") || ($current_user->roles[0] == "administrator") || ($current_user->roles[0] == "owner")  && !is_null( $content ) && !is_feed() )

return do_shortcode($content);

return '<div class="member-page">

<table width="635" align="center" border="1">
  <tr>
    <th scope="col" style=" text-align:left; padding-left: 45px;"><h2>Acheter un eCode. (cotisation membre premium)</h2></th>
  </tr>
  <tr>
    <td style=" text-align:left;"><div class="cgv-premium">D&egrave;s r&eacute;ception du montant de votre cotisation &laquo; premium &raquo; annuelle de<br />
 	12 x  3,00 soit 36,00&euro; htva
	vous recevrez sur votre adresse mail une facture acquitt&eacute;e.<br />
 	(suivant votre mode de paiement, quelques jours peuvent &ecirc;tre n&eacute;cessaire)<br /> <br />
	&laquo; Pourquoi devenir membre  <a href="http://www.laprevention.be/informations"  target="_self"><strong>premium</strong></a> &raquo;
</div>
</td>
  </tr>
  <tr>
    <td><div class="member-btn-3"><a href="http://www.laprevention.be/paiement">Devenir Membre Premium &raquo;</a></div></td>
  </tr>
</table>
</div>';

	
	
} else {
    return '<div class="member-page">

<table width="600" align="center" border="1">
  <tr>
    <th style=" text-align:center;" scope="col">&laquo; Vous devez &ecirc;tre membre Premium ou connect&eacute; pour pouvoir acheter cette fonctionnalit&eacute; &raquo; </th>
  </tr>
  <tr>
    <td><div class="member-btn"><a href="http://www.laprevention.be/login-connect">Me connecter</a></div></td>
  </tr>
  <tr>
    <td><div class="member-btn-2"><a href="http://laprevention.be/inscription/">Devenir Membre</a></div>(Inscription gratuite)</td>
  </tr>
</table>
</div>';
}




}

// shortcode access Membre
add_shortcode( 'membre', 'member_check_shortcode' );
function member_check_shortcode( $atts, $content = null ) {
if ( is_user_logged_in() && !is_null( $content ) && !is_feed() )
return do_shortcode($content);
return '<div class="member-page">

<table align="center" border="1">
  <tr>
    <th style=" text-align:center;" scope="col"><h1>Vous devez &ecirc;tre membre pour continuer.</h1></th>
  </tr>
  <tr>
    <td><div class="member-btn"><a href="http://laprevention.be/login-connect/">Se connecter</a></div></td>
  </tr>
  <tr>
    <td><div class="member-btn-2"><a href="http://laprevention.be/inscription/">Devenir membre</a></div></td>
  </tr>
  <tr>
    <td><div class="txt-premimum">(Inscription gratuite)</div></td>
  </tr>
</table>
</div>';
}


// Breadcrumbs
function custom_breadcrumbs() {
       
    // Settings
    $separator          = '&gt;';
    $breadcrums_id      = 'breadcrumbs';
    $breadcrums_class   = 'breadcrumbs';
    $home_title         = 'Accueil';
      
    // If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
    $custom_taxonomy    = 'product_cat';
       
    // Get the query & post information
    global $post,$wp_query;
       
    // Do not display on the homepage
    if ( !is_front_page() ) {
       
        // Build the breadcrums
        echo '<ul id="' . $breadcrums_id . '" class="' . $breadcrums_class . '">';
           
        // Home page
        echo '<li class="item-home"><a class="bread-link bread-home" href="' . get_home_url() . '" title="' . $home_title . '">' . $home_title . '</a></li>';
        echo '<li class="separator separator-home"> ' . $separator . ' </li>';
           
        if ( is_archive() && !is_tax() && !is_category() && !is_tag() ) {
              
            echo '<li class="item-current item-archive"><strong class="bread-current bread-archive">' . post_type_archive_title($prefix, false) . '</strong></li>';
              
        } else if ( is_archive() && is_tax() && !is_category() && !is_tag() ) {
              
            // If post is a custom post type
            $post_type = get_post_type();
              
            // If it is a custom post type display name and link
            if($post_type != 'post') {
                  
                $post_type_object = get_post_type_object($post_type);
                $post_type_archive = get_post_type_archive_link($post_type);
              
                echo '<li class="item-cat item-custom-post-type-' . $post_type . '"><a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a></li>';
                echo '<li class="separator"> ' . $separator . ' </li>';
              
            }
              
            $custom_tax_name = get_queried_object()->name;
            echo '<li class="item-current item-archive"><strong class="bread-current bread-archive">' . $custom_tax_name . '</strong></li>';
              
        } else if ( is_single() ) {
              
            // If post is a custom post type
            $post_type = get_post_type();
              
            // If it is a custom post type display name and link
            if($post_type != 'post') {
                  
                $post_type_object = get_post_type_object($post_type);
                $post_type_archive = get_post_type_archive_link($post_type);
              
                echo '<li class="item-cat item-custom-post-type-' . $post_type . '"><a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a></li>';
                echo '<li class="separator"> ' . $separator . ' </li>';
              
            }
              
            // Get post category info
            $category = get_the_category();
             
            if(!empty($category)) {
              
                // Get last category post is in
                $last_category = end(array_values($category));
                  
                // Get parent any categories and create array
                $get_cat_parents = rtrim(get_category_parents($last_category->term_id, true, ','),',');
                $cat_parents = explode(',',$get_cat_parents);
                  
                // Loop through parent categories and store in variable $cat_display
                $cat_display = '';
                foreach($cat_parents as $parents) {
                    $cat_display .= '<li class="item-cat">'.$parents.'</li>';
                    $cat_display .= '<li class="separator"> ' . $separator . ' </li>';
                }
             
            }
              
            // If it's a custom post type within a custom taxonomy
            $taxonomy_exists = taxonomy_exists($custom_taxonomy);
            if(empty($last_category) && !empty($custom_taxonomy) && $taxonomy_exists) {
                   
                $taxonomy_terms = get_the_terms( $post->ID, $custom_taxonomy );
                $cat_id         = $taxonomy_terms[0]->term_id;
                $cat_nicename   = $taxonomy_terms[0]->slug;
                $cat_link       = get_term_link($taxonomy_terms[0]->term_id, $custom_taxonomy);
                $cat_name       = $taxonomy_terms[0]->name;
               
            }
              
            // Check if the post is in a category
            if(!empty($last_category)) {
                echo $cat_display;
                echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong></li>';
                  
            // Else if post is in a custom taxonomy
            } else if(!empty($cat_id)) {
                  
                echo '<li class="item-cat item-cat-' . $cat_id . ' item-cat-' . $cat_nicename . '"><a class="bread-cat bread-cat-' . $cat_id . ' bread-cat-' . $cat_nicename . '" href="' . $cat_link . '" title="' . $cat_name . '">' . $cat_name . '</a></li>';
                echo '<li class="separator"> ' . $separator . ' </li>';
                echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong></li>';
              
            } else {
                  
                echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</strong></li>';
                  
            }
              
        } else if ( is_category() ) {
               
            // Category page
            echo '<li class="item-current item-cat"><strong class="bread-current bread-cat">' . single_cat_title('', false) . '</strong></li>';
               
        } else if ( is_page() ) {
               
            // Standard page
            if( $post->post_parent ){
                   
                // If child page, get parents 
                $anc = get_post_ancestors( $post->ID );
                   
                // Get parents in the right order
                $anc = array_reverse($anc);
                   
                // Parent page loop
                foreach ( $anc as $ancestor ) {
                    $parents .= '<li class="item-parent item-parent-' . $ancestor . '"><a class="bread-parent bread-parent-' . $ancestor . '" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '">' . get_the_title($ancestor) . '</a></li>';
                    $parents .= '<li class="separator separator-' . $ancestor . '"> ' . $separator . ' </li>';
                }
                   
                // Display parent pages
                echo $parents;
                   
                // Current page
                echo '<li class="item-current item-' . $post->ID . '"><strong title="' . get_the_title() . '"> ' . get_the_title() . '</strong></li>';
                   
            } else {
                   
                // Just display current page if not parents
                echo '<li class="item-current item-' . $post->ID . '"><strong class="bread-current bread-' . $post->ID . '"> ' . get_the_title() . '</strong></li>';
                   
            }
               
        } else if ( is_tag() ) {
               
            // Tag page
               
            // Get tag information
            $term_id        = get_query_var('tag_id');
            $taxonomy       = 'post_tag';
            $args           = 'include=' . $term_id;
            $terms          = get_terms( $taxonomy, $args );
            $get_term_id    = $terms[0]->term_id;
            $get_term_slug  = $terms[0]->slug;
            $get_term_name  = $terms[0]->name;
               
            // Display the tag name
            echo '<li class="item-current item-tag-' . $get_term_id . ' item-tag-' . $get_term_slug . '"><strong class="bread-current bread-tag-' . $get_term_id . ' bread-tag-' . $get_term_slug . '">' . $get_term_name . '</strong></li>';
           
        } elseif ( is_day() ) {
               
            // Day archive
               
            // Year link
            echo '<li class="item-year item-year-' . get_the_time('Y') . '"><a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a></li>';
            echo '<li class="separator separator-' . get_the_time('Y') . '"> ' . $separator . ' </li>';
               
            // Month link
            echo '<li class="item-month item-month-' . get_the_time('m') . '"><a class="bread-month bread-month-' . get_the_time('m') . '" href="' . get_month_link( get_the_time('Y'), get_the_time('m') ) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</a></li>';
            echo '<li class="separator separator-' . get_the_time('m') . '"> ' . $separator . ' </li>';
               
            // Day display
            echo '<li class="item-current item-' . get_the_time('j') . '"><strong class="bread-current bread-' . get_the_time('j') . '"> ' . get_the_time('jS') . ' ' . get_the_time('M') . ' Archives</strong></li>';
               
        } else if ( is_month() ) {
               
            // Month Archive
               
            // Year link
            echo '<li class="item-year item-year-' . get_the_time('Y') . '"><a class="bread-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</a></li>';
            echo '<li class="separator separator-' . get_the_time('Y') . '"> ' . $separator . ' </li>';
               
            // Month display
            echo '<li class="item-month item-month-' . get_the_time('m') . '"><strong class="bread-month bread-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . ' Archives</strong></li>';
               
        } else if ( is_year() ) {
               
            // Display year archive
            echo '<li class="item-current item-current-' . get_the_time('Y') . '"><strong class="bread-current bread-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . ' Archives</strong></li>';
               
        } else if ( is_author() ) {
               
            // Auhor archive
               
            // Get the author information
            global $author;
            $userdata = get_userdata( $author );
               
            // Display author name
            echo '<li class="item-current item-current-' . $userdata->user_nicename . '"><strong class="bread-current bread-current-' . $userdata->user_nicename . '" title="' . $userdata->display_name . '">' . 'Author: ' . $userdata->display_name . '</strong></li>';
           
        } else if ( get_query_var('paged') ) {
               
            // Paginated archives
            echo '<li class="item-current item-current-' . get_query_var('paged') . '"><strong class="bread-current bread-current-' . get_query_var('paged') . '" title="Page ' . get_query_var('paged') . '">'.__('Page') . ' ' . get_query_var('paged') . '</strong></li>';
               
        } else if ( is_search() ) {
           
            // Search results page
            echo '<li class="item-current item-current-' . get_search_query() . '"><strong class="bread-current bread-current-' . get_search_query() . '" title="Search results for: ' . get_search_query() . '">Search results for: ' . get_search_query() . '</strong></li>';
           
        } elseif ( is_404() ) {
               
            // 404 page
            echo '<li>' . 'Error 404' . '</li>';
        }
       
        echo '</ul>';
           
    }
       
}

// Woocommerce
// Skip the cart and redirect to check out url when clicking on Add to cart
add_filter ( 'add_to_cart_redirect', 'redirect_to_checkout' );
function redirect_to_checkout() {
    
	global $woocommerce;
	// Remove the default `Added to cart` message
	wc_clear_notices();
	return $woocommerce->cart->get_checkout_url();
	
}
// Global redirect to check out when hitting cart page
//add_action( 'template_redirect', 'redirect_to_checkout_if_cart' );
function redirect_to_checkout_if_cart() {
	
	if ( !is_cart() ) return;
	global $woocommerce;
    // Redirect to check out url
	wp_redirect( $woocommerce->cart->get_checkout_url(), '301' );
	exit;
	
}
// Empty cart each time you click on add cart to avoid multiple element selected
add_action( 'woocommerce_add_cart_item_data', 'clear_cart', 0 );
function clear_cart () {
	global $woocommerce;
	$woocommerce->cart->empty_cart();
}
// Edit default add_to_cart button text
add_filter( 'add_to_cart_text', 'woo_custom_cart_button_text' );
add_filter( 'woocommerce_product_single_add_to_cart_text', 'custom_cart_button_text' );
function custom_cart_button_text() {
	return __( 'Buy', 'woocommerce' );
}
// Unset all options related to the cart
update_option( 'woocommerce_cart_redirect_after_add', 'no' );
update_option( 'woocommerce_enable_ajax_add_to_cart', 'no' );


function sv_require_wc_company_field( $fields ) {
    $fields['company']['required'] = true;
    return $fields;
}
add_filter( 'woocommerce_default_address_fields', 'sv_require_wc_company_field' );

function sv_unrequire_wc_phone_field( $fields ) {
    $fields['billing_phone']['required'] = false;
    return $fields;
}
add_filter( 'woocommerce_billing_fields', 'sv_unrequire_wc_phone_field' );

// Remove fields
add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );
 
function custom_override_checkout_fields( $fields ) {
    unset($fields['billing']['billing_first_name']);
    unset($fields['billing']['billing_last_name']);
    unset($fields['billing']['billing_company']);
    unset($fields['billing']['billing_address_1']);
    unset($fields['billing']['billing_address_2']);
    unset($fields['billing']['billing_city']);
    unset($fields['billing']['billing_postcode']);
    unset($fields['billing']['billing_country']);
    unset($fields['billing']['billing_state']);
    unset($fields['billing']['billing_phone']);
    //unset($fields['order']['order_comments']);
    unset($fields['billing']['billing_address_2']);
    unset($fields['billing']['billing_postcode']);
    unset($fields['billing']['billing_company']);
    unset($fields['billing']['billing_last_name']);
    unset($fields['billing']['billing_email']);
    unset($fields['billing']['billing_city']);
    return $fields;
}

 
add_filter( 'woocommerce_default_address_fields', 'my_default_address_fields' );
function my_default_address_fields( $fields ) {
  //move these around in the order you'd like
  $fields2['first_name'] = $fields['first_name'];
  $fields2['last_name'] = $fields['last_name'];
  $fields2['email'] = $fields['email'];
  $fields2['company'] = $fields['company'];
  $fields2['address_1'] = $fields['address_1'];
  $fields2['postcode'] = $fields['postcode'];
  $fields2['city'] = $fields['city'];
  $fields2['city']['label'] = 'City';
  $fields2['city']['placeholder'] = 'City';
  $fields2['country'] = $fields['country'];
  $fields2['state'] = $fields['state'];
  $fields2['phone'] = $fields['phone'];

  return $fields2;
}


// Hook in
add_filter( 'woocommerce_billing_fields', 'rs_custom_billing_fields' );

// Function Hook
Function rs_custom_billing_fields( $fields )  {
	$fields['first_name'] = array(
		'label'     	=> __('Prénom', 'woocommerce'),
		'placeholder'   => _x('', 'placeholder', 'woocommerce'),
		'required'  	=> true,
		'class'     	=> array('form-row-first'), 
		'clear'     	=> false
    );
	
	$fields['last_name'] = array(
		'label'     	=> __('Nom', 'woocommerce'),
		'placeholder'   => _x('', 'placeholder', 'woocommerce'),
		'required'  	=> true,
		'class'     	=> array('form-row-last'),	
		'clear'     	=> true			
    );
	
	$fields['rue'] = array(
		'label'     	=> __('Adresse', 'woocommerce'),
		'placeholder'   => _x('', 'placeholder', 'woocommerce'),
		'required'  	=> true,
		'class'     	=> array('input-text'),	
		'clear'     	=> true			
    );
	
	$fields['ville'] = array(
		'label'     	=> __('Ville', 'woocommerce'),
		'placeholder'   => _x('', 'placeholder', 'woocommerce'),
		'required'  	=> true,
		'class'     	=> array('form-row-first'), 
		'clear'     	=> false
    );
	
	$fields['code'] = array(
		'label'     	=> __('Code postal', 'woocommerce'),
		'placeholder'   => _x('', 'placeholder', 'woocommerce'),
		'required'  	=> true,
		'class'     	=> array('form-row-last'),	
		'clear'     	=> true			
    );
	
	$fields['pays'] = array(
		'label'     	=> __('Pays', 'woocommerce'),
		'placeholder'   => _x('', 'placeholder', 'woocommerce'),
		'required'  	=> true,
		'class'     	=> array('input-text'),	
		'clear'     	=> true			
    );
	
	$fields['phone'] = array(
		'label'     	=> __('Téléphone', 'woocommerce'),
		'placeholder'   => _x('', 'placeholder', 'woocommerce'),
		'required'  	=> true,
		'class'     	=> array('input-text'),	
		'clear'     	=> true			
    );
	
	$fields['tva'] = array(
		'label'     	=> __('N° entreprise ou TVA Intra', 'woocommerce'),
		'placeholder'   => _x('', 'placeholder', 'woocommerce'),
		'required'  	=> false,
		'class'     	=> array('input-text'),	
		'clear'     	=> true			
    );

    // just copy same format if you'd like to add more fields

	return $fields;
}

function addme_ajaxurl() {
?>
<script type="text/javascript">
var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
</script>
<?php
}
add_action('wp_head','addme_ajaxurl');

add_action('wp_ajax_submit_form', 'submit_form_callback');
function submit_form_callback(){
 
 $params = array();
    parse_str($_POST['data'], $params);

  $name = trim($params['name']);
 $email = $params['email'];
 $message = $params['message'];
 $subject = $params['subject'];
 $site_owners_email = 'fred@naxialis.com'; // Replace this with your own email address
 
 if ($name=="") {
 $error['name'] = "Please enter your name"; 
 }
 
 if ($email=="") {
 $error['email'] = "Please enter a valid email address"; 
 }
 
 if ($message== "") {
 $error['message'] = "Please leave a comment.";
 }
 if ($subject=="") {
 $error['subject'] = "Please leave a subject.";
 }
 if (!$error) {
 
 $mail = mail($site_owners_email, $subject, $message,
 "From: ".$name." <".$email.">rn"
 ."Reply-To: ".$email."rn"
 ."X-Mailer: PHP/" . phpversion());
 $success['success'] = "<div class='success'>" . $name . ", We've received your email. We'll be in touch with you as soon as possible! </div>";
 
 echo json_encode($success);
 
 } # end if no error
 else {

  echo json_encode($error);
 } # end if there was an error sending
 
    die(); // this is required to return a proper result
}