<?php class MyWidget extends WP_Widget {

    function __construct() {
        $widget_ops = array( 'description' => __('Utilisez ce widget pour ajouter un de vos menu personnalisé sous forme de menu déroulant vertical.') );
        parent::__construct( 'vertical_menu_widget_nax', __('Menu vertical'), $widget_ops );
    }

    function widget($args, $instance) {
        // Get menu
        $nav_menu = ! empty( $instance['nav_menu'] ) ? wp_get_nav_menu_object( $instance['nav_menu'] ) : false;

        if ( !$nav_menu )
            return;

        $instance['title'] = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		
		$id_menu_vertical = $instance['menu_v_class'];



        echo $args['before_widget'];
		
		echo "<script>
		//Menu vertical
jQuery(document).ready(function(){
		
		var example = $('#".$id_menu_vertical."').superfish({
			animation: {height:'show'},	// slide-down effect without fade-in
			delay: 1200			// 1.2 second delay on mouseout
		});
	}); </script>";
		
		

        if ( !empty($instance['title']) )
            echo $args['before_title'] . $instance['title'] . $args['after_title'];

       
		
		
		
		wp_nav_menu( array(
	'menu' => $nav_menu,
    'theme_location' => 'main-menu', // Setting up the location for the main-menu, Main Navigation.
    'menu_class' => 'sf-menu sf-vertical', //Adding the class for dropdowns
    'container_id' => $id_menu_vertical, //Add CSS ID to the containter that wraps the menu.
    'fallback_cb' => 'wp_page_menu', //if wp_nav_menu is unavailable, WordPress displays wp_page_menu function, which displays the pages of your blog.
    )
      );

        echo $args['after_widget'];

    }

    function update( $new_instance, $old_instance ) {
        $instance['title'] = strip_tags( stripslashes($new_instance['title']) );
		 $instance['menu_v_class'] = strip_tags( stripslashes($new_instance['menu_v_class']) );
        $instance['nav_menu'] = (int) $new_instance['nav_menu'];
        return $instance;
    }

    function form( $instance ) {
        $title = isset( $instance['title'] ) ? $instance['title'] : '';
		$menu_v_class = isset( $instance['menu_v_class'] ) ? $instance['menu_v_class'] : '';
        $nav_menu = isset( $instance['nav_menu'] ) ? $instance['nav_menu'] : '';

        // Get menus
        $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );

        // If no menus exists, direct the user to go and create some.
        if ( !$menus ) {
            echo '<p>'. sprintf( __('No menus have been created yet. <a href="%s">Create some</a>.'), admin_url('nav-menus.php') ) .'</p>';
            return;
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:') ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $title; ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id('menu_v_class'); ?>"><?php _e('Identifiant du menu(*):') ?></label>
            <input type="text" class="menu_v" size="15" id="<?php echo $this->get_field_id('menu_v_class'); ?>" name="<?php echo $this->get_field_name('menu_v_class'); ?>" value="<?php echo $menu_v_class; ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id('nav_menu'); ?>"><?php _e('Select Menu:'); ?></label>
            <select id="<?php echo $this->get_field_id('nav_menu'); ?>" name="<?php echo $this->get_field_name('nav_menu'); ?>">
        <?php
            foreach ( $menus as $menu ) {
                $selected = $nav_menu == $menu->term_id ? ' selected="selected"' : '';
                echo '<option'. $selected .' value="'. $menu->term_id .'">'. $menu->name .'</option>';
            }
        ?>
            </select>
        </p>
        <?php
    }
}

add_action( 'widgets_init', 'myplugin_register_widgets' );

function myplugin_register_widgets() {

      register_widget( 'MyWidget' );

}