<?php class SocialWidget extends WP_Widget {

    function __construct() {
        $widget_ops = array( 'description' => __('Profil de vos réseaux sociaux.') );
		 $control_ops = array(
     'width' => 250,
     'height' => 250,
     'id_base' => 'nax-social-widget');
        parent::__construct( 'nax-social-widget', __('Vos réseaux sociaux'), $widget_ops,$control_ops  );
    }
	
	
	

    function widget($args, $instance) {
       

        $instance['title'] = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		
		$id_facebook = $instance['facebook_class'];
		$id_google_p = $instance['google_class'];
		$id_twitter = $instance['twitter_class'];
		$id_in = $instance['in_class'];
		$id_pint = $instance['pint_class'];
		$id_rss = $instance['rss_class'];


        echo $args['before_widget'];
		
		
		
		

        if ( !empty($instance['title']) )
            echo $args['before_title'] . $instance['title'] . $args['after_title'];
		
		echo '<div class="profil-story">';
			
		echo '<ul>';	

		if ($instance['facebook_class'])  {
		
		echo '<li class="icon-facebook-profile"><a href="'.$id_facebook.'" title="Facebook" onclick="window.open(this.href); return false;"></a></li>';
		} else {};
		
		if ($instance['google_class'])  {
		
		echo '<li class="icon-gplus-profile"><a class="google-plus" href="'.$id_google_p.'" onclick="window.open(this.href); return false;"></a></li></li>';
		} else {};
		
		if ($instance['twitter_class'])  {
		
		echo '<li class="icon-twitter-profile"><a class="twitter" href="'.$id_twitter.'" onclick="window.open(this.href); return false;"></a></li>';
		} else {};
		
		if ($id_in = $instance['in_class'])  {
		
		echo '<li class="icon-linkedin-profile"><a href="'.$id_in.'" onclick="window.open(this.href); return false;"></a></li>';
		} else {};
		
		if ($id_pint = $instance['pint_class'])  {
		
		echo '<li class="icon-pinterest-profile"><a href="'.$id_pint.'" onclick="window.open(this.href); return false;"></a></li>';
		} else {};
		
		if ($id_rss = $instance['rss_class'])  {
		
		echo '<li class="icon-rss"><a href="'.$id_pint.'" onclick="window.open(this.href); return false;"></a></li>';
		} else {};

       
		echo '</ul>';
		echo '</div>';


        echo $args['after_widget'];

    }

    function update( $new_instance, $old_instance ) {
        $instance['title'] = strip_tags( stripslashes($new_instance['title']) );
		$instance['facebook_class'] = strip_tags( stripslashes($new_instance['facebook_class']) );
		$instance['rss_class'] = strip_tags( stripslashes($new_instance['rss_class']) );
		$instance['pint_class'] = strip_tags( stripslashes($new_instance['pint_class']) );
		$instance['in_class'] = strip_tags( stripslashes($new_instance['in_class']) );
		$instance['google_class'] = strip_tags( stripslashes($new_instance['google_class']) );
		$instance['twitter_class'] = strip_tags( stripslashes($new_instance['twitter_class']) );
       
        return $instance;
    }

    function form( $instance ) {
        $title = isset( $instance['title'] ) ? $instance['title'] : '';
		$facebook_class = isset( $instance['facebook_class'] ) ? $instance['facebook_class'] : '';
		$rss_class = isset( $instance['rss_class'] ) ? $instance['rss_class'] : '';
		$twitter_class = isset( $instance['twitter_class'] ) ? $instance['twitter_class'] : '';
		$google_class = isset( $instance['google_class'] ) ? $instance['google_class'] : '';
		$in_class = isset( $instance['in_class'] ) ? $instance['in_class'] : '';
		$pint_class = isset( $instance['pint_class'] ) ? $instance['pint_class'] : '';
       

       
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:') ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $title; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('rss_class'); ?>"><?php _e('Rss:') ?></label>
            <input type="text" class="widefat"  id="<?php echo $this->get_field_id('rss_class'); ?>" name="<?php echo $this->get_field_name('rss_class'); ?>" value="<?php echo $rss_class; ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('facebook_class'); ?>"><?php _e('Facebook:') ?></label>
            <input type="text" class="widefat"  id="<?php echo $this->get_field_id('facebook_class'); ?>" name="<?php echo $this->get_field_name('facebook_class'); ?>" value="<?php echo $facebook_class; ?>" />
        </p>
        
         <p>
            <label for="<?php echo $this->get_field_id('twitter_class'); ?>"><?php _e('Twitter:') ?></label>
            <input type="text" class="widefat"  id="<?php echo $this->get_field_id('twitter_class'); ?>" name="<?php echo $this->get_field_name('twitter_class'); ?>" value="<?php echo $twitter_class; ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id('google_class'); ?>"><?php _e('Google +:') ?></label>
            <input type="text" class="widefat"  id="<?php echo $this->get_field_id('google_class'); ?>" name="<?php echo $this->get_field_name('google_class'); ?>" value="<?php echo $google_class; ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id('in_class'); ?>"><?php _e('Linkedin:') ?></label>
            <input type="text" class="widefat"  id="<?php echo $this->get_field_id('in_class'); ?>" name="<?php echo $this->get_field_name('in_class'); ?>" value="<?php echo $in_class; ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_id('pint_class'); ?>"><?php _e('Pinterest:') ?></label>
            <input type="text" class="widefat"  id="<?php echo $this->get_field_id('pint_class'); ?>" name="<?php echo $this->get_field_name('pint_class'); ?>" value="<?php echo $pint_class; ?>" />
        </p>
       
        
       
        <?php
    }
}


add_action('widgets_init',
     create_function('', 'return register_widget("SocialWidget");')
);

