<?php
/**
 * @package WordPress
 * @subpackage Default_Theme
 */

// Do not delete these lines
	if (isset($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('');
	
	if ( post_password_required() ) { ?>
		<p class="nocomments"><?php _e('This post is password protected. Enter the password to view comments.'); ?></p> 
	<?php
		return;
	}
?>

<!-- You can start editing here. -->

<?php if ( have_comments() ) : ?>
	<h3  class="comment-title"><?php comments_number(__('Pas de Commentaires'), __(' 1 Commentaire'), __('% Commentaires'));?> <?php printf(__('pour &#8220;%s&#8221;'), the_title('', '', false)); ?></h3>

	<div class="navigation">
		<div class="alignleft"><?php previous_comments_link() ?></div>
		<div class="alignright"><?php next_comments_link() ?></div>
	</div>

	<ol class="commentlist">
	<?php wp_list_comments("callback=mytheme_comment");?>
	</ol>

	<div class="navigation">
		<div class="alignleft"><?php previous_comments_link() ?></div>
		<div class="alignright"><?php next_comments_link() ?></div>
	</div>
 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->

	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<p class="nocomments"><?php _e('-.'); ?></p>

	<?php endif; ?>
<?php endif; ?>


<?php if ( comments_open() ) : ?>

<div id="respond">

<h3 class="comment-h3"><?php comment_form_title( __('Laisser un commentaire'), __('Laisser un commentaire pour la %s') ); ?></h3>

<div id="cancel-comment-reply"> 
	<small><?php cancel_comment_reply_link() ?></small>
</div> 

<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
<p><?php printf(__('Vous devez &ecirc;tre <a href="%s">connect&eacute;</a> pour ajout&eacute; un commentaire.'), wp_login_url( get_permalink() )); ?></p>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ( is_user_logged_in() ) : ?>

<p><?php printf(__('Connect&eacute; en tant que <a href="%1$s">%2$s</a>.'), get_option('siteurl') . '/wp-admin/profile.php', $user_identity); ?> <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('D&eacute;connectez-vous de ce compte'); ?>"><?php _e('D&eacute;connectez &raquo;'); ?></a></p>

<?php else : ?>
<div class="comment-div">
<label for="author"><small><?php _e('Nom'); ?> <?php if ($req) _e("(*)"); ?></small></label>
<input type="text" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" size="22" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> /><br />


<label for="email"><small><?php _e(' E-mail (ne sera pas publi&eacute;)'); ?> <?php if ($req) _e("(*)"); ?></small></label>
<input type="text" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" size="22" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> /><br />


<label for="url"><small><?php _e('Site Web'); ?></small></label>
<input type="text" name="url" id="url" value="<?php echo  esc_attr($comment_author_url); ?>" size="22" tabindex="3" /><br />

</div>
<?php endif; ?>


<div class="comment-textarea">
<textarea name="comment" id="comment" cols="58" rows="10" tabindex="4"></textarea>
<div class="code-tags"><small><?php printf(__('<strong>XHTML:</strong> You can use these tags: <code>%s</code>'), allowed_tags()); ?></small></div>
<input name="submit" type="submit" id="submit" tabindex="5" value="<?php _e('Envoyer'); ?>" />
</div>

<?php comment_id_fields(); ?> 

<?php do_action('comment_form', $post->ID); ?>

</form>

<?php endif; // If registration required and not logged in ?>
</div>

<?php endif; // if you delete this the sky will fall on your head ?>
