<?php
add_theme_support( 'automatic-feed-links' );
add_editor_style('editor-style.css');
add_theme_support( 'post-thumbnails', array( 'post' ) );

add_image_size( 'simplicy-small-thumbnail', 158, 100, true );
add_image_size( 'shortcode-thumbnail-3', 215, 145, true );
add_image_size( 'simplicy-thumbnail-fullwidth', 308, 220, true );
add_image_size( 'simplicy-large', 630, 9999, false );

// registration link
add_action( 'login_head', 'hide_login_nav' );

function hide_login_nav()
{
    ?><style>#nav,#backtoblog{display:none}</style><?php
}

function stop_plugin_update( $value ) {
unset( $value->response['newsletter/plugin.php'] );
return $value;
}

add_filter( 'site_transient_update_plugins', 'stop_plugin_update' );

// Ajout d'un nouveau rle "Premium"
$result = add_role('Premium_role', 'Abonnement Premium', array(
    'read' => true, // True allows that capability
    'edit_posts' => true,
    'delete_posts' => false, // Use false to explicitly deny
));


remove_role( 'contributor' );

function modify_capabilities() {
	$editor_role = get_role('editor');
	add_role('owner', 'Verificateur', $editor_role->capabilities);
	$owner_role = get_role('owner');
	$owner_role->add_cap('edit_others_posts');
	$owner_role->add_cap('edit_posts');
	$owner_role->add_cap('edit_others_pages');
	
	$owner_role->remove_cap('delete_others_posts');
	$owner_role->remove_cap('upload_files');
	$owner_role->remove_cap('manage_categories');
	$owner_role->remove_cap('manage_links');
	$owner_role->remove_cap('delete_others_pages');
	
}
add_action('init','modify_capabilities');

add_action( 'init', 'blockusers_init' );
function blockusers_init() {
if ( is_admin() && ! current_user_can( 'administrator' ) &&
! ( defined( 'DOING_AJAX' ) && DOING_AJAX ) ) {
wp_redirect( home_url() );
exit;
}
}


// Shortcode premium 
include (TEMPLATEPATH .'/membre/extra_admin.php');
// shortcode access Membre
add_shortcode( 'Premium', 'member_premium_shortcode' );
function member_premium_shortcode( $atts, $content = null ) {

if ( is_user_logged_in() ) {
    
	global $current_user;
if (($current_user->roles[0] == "Premium_role") || ($current_user->roles[0] == "administrator") || ($current_user->roles[0] == "owner")  && !is_null( $content ) && !is_feed() )

return do_shortcode($content);

return '<div class="member-page">

<table width="635" align="center" border="1">
  <tr>
    <th scope="col" style=" text-align:left; padding-left: 45px;"><h2>Acheter un eCode. (cotisation membre premium)</h2></th>
  </tr>
  <tr>
    <td style=" text-align:left;"><div class="cgv-premium">D&egrave;s r&eacute;ception du montant de votre cotisation &laquo; premium &raquo; annuelle de<br />
 	12 x  3,00 soit 36,00&euro; htva
	vous recevrez sur votre adresse mail une facture acquitt&eacute;e.<br />
 	(suivant votre mode de paiement, quelques jours peuvent &ecirc;tre n&eacute;cessaire)<br /> <br />
	&laquo; Pourquoi devenir membre  <a href="http://www.laprevention.be/informations"  target="_self"><strong>premium</strong></a> &raquo;
</div>
</td>
  </tr>
  <tr>
    <td><div class="member-btn-3"><a href="http://www.laprevention.be/paiement">Devenir Membre Premium &raquo;</a></div></td>
  </tr>
</table>
</div>';

	
	
} else {
    return '<div class="member-page">

<table width="600" align="center" border="1">
  <tr>
    <th style=" text-align:center;" scope="col">&laquo; Vous devez &ecirc;tre membre ou connect&eacute; pour pouvoir acheter cette fonctionnalit&eacute; &raquo; </th>
  </tr>
  <tr>
    <td><div class="member-btn"><a href="http://www.laprevention.be/login-connect">Me connecter</a></div></td>
  </tr>
  <tr>
    <td><div class="member-btn-2"><a href="http://laprevention.be/inscription/">Devenir Membre</a></div>(Inscription gratuite)</td>
  </tr>
</table>
</div>';
}




}




// Create a function for register_nav_menus()
function add_wp3menu_support() {
 
register_nav_menus(
        array(
        'main-menu' => __('Menu Principal')
        )
     );
 
}
 

add_action('init', 'add_wp3menu_support');
//Add link home menu 1.

add_filter('wp_nav_menu_items','home_menu_1_function', 10, 2);
function home_menu_1_function( $items, $args ) {
    if( $args->theme_location == 'main-menu' )
	
        $homeMenuItem =
                '<li class="menu-1">' .
                $args->before .
                '<a href="' . home_url( '/' ) . '" title="Home">' .
                $args->link_before . 'Accueil' . $args->link_after .
                '</a>' .
                $args->after .
                '</li>';
  
        $items = $homeMenuItem . $items;
  
    return $items;
}
// menu fin

// e-mail de notification
function new_email_from()
{
 return 'info@bucoweb.be';
}
 
function new_email_from_name()
{
 return 'La  Prevention';
}
 
add_filter('wp_mail_from', 'new_email_from');
add_filter('wp_mail_from_name', 'new_email_from_name'); 

// fonction dsativer menu utilateur

function my_function_admin_bar($content) {

    return ( current_user_can("administrator") ) ? $content : false;

}

add_filter( 'show_admin_bar' , 'my_function_admin_bar');

function register_my_widget_theme()  {

// sidebar pour le header widget connexion

	register_sidebar(array(

		'id' => 'widget-login', // identifiant

		'name' => 'Widget Login', // Nom a afficher dans le tableau de bord

		'description' => 'Emplacement pour le widget connexion.', // description facultatif

		'before_widget' => '<li id="%1$s" class="widget %2$s">', // class attribuer pour le contenu (css)

		'after_widget' => '</li>',

		'before_title' => '<h2 class="widgettitle">', // class attribuer  pour le titre (css)

		'after_title' => '</h2>',

	));
	}
add_action( 'init', 'register_my_widget_theme' );

if ( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h2 class="widgettitle">',
		'after_title' => '</h2>',
	));
	
	register_sidebar(array('name'=>'Sidebar-2 ',
'before_widget' => '<li id="%1$s" class="widget %2$s">',
'after_widget' => '</li>',
'before_title' => '<h2 class="widgettitle">',
'after_title' => '</h2>',
));

register_sidebar(array('name'=>'Sidebar-3 ',
'before_widget' => '<li id="%1$s" class="widget %2$s">',
'after_widget' => '</li>',
'before_title' => '<h2 class="widgettitle">',
'after_title' => '</h2>',
));

register_sidebar(array('name'=>'Sidebar-4 ',
'before_widget' => '<li id="%1$s" class="widget %2$s">',
'after_widget' => '</li>',
'before_title' => '<h2 class="widgettitle">',
'after_title' => '</h2>',
));

register_sidebar(array('name'=>'Sidebar-5 ',
'before_widget' => '<li id="%1$s" class="widget %2$s">',
'after_widget' => '</li>',
'before_title' => '<h2 class="widgettitle">',
'after_title' => '</h2>',
));

}
// widget bas de page
if ( function_exists('register_sidebar') )

register_sidebar(array('name'=>'Footer Widget 1',
'before_widget' => '<div class="widget-footer">',
'after_widget' => '<div class="cleaner">&nbsp;</div>
  </div>',
'before_title' => '<h2 class="widget-footer-title">',
'after_title' => '</h2>',
));



register_sidebar(array('name'=>'Footer Widget 2',
'before_widget' => '<div class="widget-footer">',
'after_widget' => '<div class="cleaner">&nbsp;</div>
  </div>',
'before_title' => '<h2 class="widget-footer-title">',
'after_title' => '</h2>',
));

register_sidebar(array('name'=>'Footer Widget 3',
'before_widget' => '<div class="widget-footer">',
'after_widget' => '<div class="cleaner">&nbsp;</div>
  </div>',
'before_title' => '<h2 class="widget-footer-title">',
'after_title' => '</h2>',
));

register_sidebar(array('name'=>'Footer Widget 4',
'before_widget' => '<div class="widget-footer">',
'after_widget' => '<div class="cleaner">&nbsp;</div>
  </div>',
'before_title' => '<h2 class="widget-footer-title">',
'after_title' => '</h2>',
));


// Option du thme
if ( !function_exists( 'optionsframework_init' ) ) {
if ( STYLESHEETPATH == TEMPLATEPATH ) {
	define('OPTIONS_FRAMEWORK_URL', TEMPLATEPATH . '/admin/');
	define('OPTIONS_FRAMEWORK_DIRECTORY', get_bloginfo('template_directory') . '/admin/');
} else {
	define('OPTIONS_FRAMEWORK_URL', STYLESHEETPATH . '/admin/');
	define('OPTIONS_FRAMEWORK_DIRECTORY', get_bloginfo('stylesheet_directory') . '/admin/');
}

require_once (OPTIONS_FRAMEWORK_URL . 'options-framework.php');

}



// pignation
function naxialis_pagination($pages = '', $range = 1)
{  
     $showitems = ($range * 3)-1;  

     global $paged;
     if(empty($paged)) $paged = 1;

     if($pages == '')
     {
         global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }   

     if(1 != $pages)
     {
         echo "<div class='pagination-pages'>";
         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo;</a>";
         if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
             }
         }

         if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'>&rsaquo;</a>";  
         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>&raquo;</a>";
         echo "</div>\n";
     }
}

// pignation fin

// This theme uses Featured Images (also known as post thumbnails) for per-post/per-page Custom Header images
	add_theme_support( 'post-thumbnails' );
	

function vp_get_thumb_url($text)
{
  global $post;
 
  $imageurl="";        
 
  // extract the thumbnail from attached imaged
  $allimages =&get_children('post_type=attachment&post_mime_type=image&post_parent=' . $post->ID );        
 
  foreach ($allimages as $img){                
     $img_src = wp_get_attachment_image_src($img->ID);
     break;                       
  }
 
  $imageurl=$img_src[0];
 
 
  // try to get any image
  if (!$imageurl)
  {
    preg_match('/<\s*img [^\>]*src\s*=\s*[\""\']?([^\""\'>]*)/i' ,  $text, $matches);
    $imageurl=$matches[1];
  }
 
  // try to get youtube video thumbnail
  
  if (!$imageurl)
  {
    preg_match("/([a-zA-Z0-9\-\_]+\.|)youtube\.com\/watch(\?v\=|\/v\/)([a-zA-Z0-9\-\_]{11})([^<\s]*)/", $text, $matches2);
 
    $youtubeurl = $matches2[0];
    if ($youtubeurl)
     $imageurl = "http://i.ytimg.com/vi/{$matches2[3]}/1.jpg"; 
   else preg_match("/([a-zA-Z0-9\-\_]+\.|)youtube\.com\/(v\/)([a-zA-Z0-9\-\_]{11})([^<\s]*)/", $text, $matches2);
 
   $youtubeurl = $matches2[0];
   if ($youtubeurl)
     $imageurl = "http://i.ytimg.com/vi/{$matches2[3]}/1.jpg"; 
  }
 
 
return $imageurl;
}



// fonction image 2013

function sp_resize( $url, $width, $height = null, $crop = null, $single = true ) {

	//validate inputs
	if(!$url OR !$width ) return false;

	//define upload path & dir
	$upload_info = wp_upload_dir();
	$upload_dir = $upload_info['basedir'];
	$upload_url = $upload_info['baseurl'];

	//check if $img_url is local
	if(strpos( $url, $upload_url ) === false) return false;

	//define path of image
	$rel_path = str_replace( $upload_url, '', $url);
	$img_path = $upload_dir . $rel_path;

	//check if img path exists, and is an image indeed
	if( !file_exists($img_path) OR !getimagesize($img_path) ) return false;

	//get image info
	$info = pathinfo($img_path);
	$ext = $info['extension'];
	list($orig_w,$orig_h) = getimagesize($img_path);

	//get image size after cropping
	$dims = image_resize_dimensions($orig_w, $orig_h, $width, $height, $crop);
	$dst_w = $dims[4];
	$dst_h = $dims[5];

	//use this to check if cropped image already exists, so we can return that instead
	$suffix = "{$dst_w}x{$dst_h}";
	$dst_rel_path = str_replace( '.'.$ext, '', $rel_path);
	$destfilename = "{$upload_dir}{$dst_rel_path}-{$suffix}.{$ext}";

	//if orig size is smaller
	if($width >= $orig_w) {

		if(!$dst_h) :
			//can't resize, so return original url
			$img_url = $url;
			$dst_w = $orig_w;
			$dst_h = $orig_h;

		else :
			//else check if cache exists
			if(file_exists($destfilename) && getimagesize($destfilename)) {
				$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
			} 
			//else resize and return the new resized image url
			else {
				$resized_img_path = image_resize( $img_path, $width, $height, $crop );
				$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
				$img_url = $upload_url . $resized_rel_path;
			}

		endif;

	}
	//else check if cache exists
	elseif(file_exists($destfilename) && getimagesize($destfilename)) {
		$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
	} 
	//else, we resize the image and return the new resized image url
	else {
		$resized_img_path = image_resize( $img_path, $width, $height, $crop );
		$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
		$img_url = $upload_url . $resized_rel_path;
	}

	//return the output
	if($single) {
		//str return
		$image = $img_url;
	} else {
		//array return
		$image = array (
			0 => $img_url,
			1 => $dst_w,
			2 => $dst_h
		);
	}

	return $image;
}



// longueur extrait




function excerpt($limit) {
      $excerpt = explode(' ', get_the_excerpt(), $limit);
      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'...';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
      $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
      return $excerpt;
    }

    function content($limit) {
      $content = explode(' ', get_the_content(), $limit);
      if (count($content)>=$limit) {
        array_pop($content);
        $content = implode(" ",$content).'...';
      } else {
        $content = implode(" ",$content);
      } 
      $content = preg_replace('/\[.+\]/','', $content);
      $content = apply_filters('the_content', $content); 
      $content = str_replace(']]>', ']]&gt;', $content);
      return $content;
    }

// Add  twitter/facebook
function the_share(){
global $post;
?>
<div class="twitt-fb">
 
<a href="http://twitter.com/share"
 
class="twitter-share-button"
 
data-count="horizontal">Tweet</a>
 
 <script type="text/javascript"
 
src="http://platform.twitter.com/widgets.js"></script>
 </div>
<div class="facebook-share-button">
 
 <iframe
 
src="http://www.facebook.com/plugins/like.php?href=<?php echo urlencode(get_permalink($post->ID)); ?>&layout=button_count&show_faces=false&width=200&action=like&colorscheme=light&height=21"
 
scrolling="no" frameborder="0" style="border:none;
 
overflow:hidden; width:90px; height:21px;"
 
allowTransparency="true"></iframe>
 
 </div>
          <div id="fb-root">
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) {return;}
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/fr_FR/all.js#xfbml=1";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>
<div class="fb-send" data-href="<?php echo urlencode(get_permalink($post->ID)); ?>"></div>
</div>
 <div class="g-plus">
<g:plusone size="medium"></g:plusone>
<script type="text/javascript">gapi.plusone.go();</script>
 </div>
 
<?php } ?>
<?php
// share +
function the_share_plus(){
global $post;
?>
<div id="button">
<img src="<?php bloginfo('template_url'); ?>/images/button.png" width="45" height="25" class="menu_class" />
<ul class="the_menu">
<br />
<li class="digg"><a href="http://digg.com/submit?phase=2&amp;url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="Partager sur Digg" target="_blank">Partager sur Digg</a></li>
<br />
<li class="delicious"><a href="http://del.icio.us/post?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="Partager sur Delicious." target="_blank">Partager sur Delicious</a></li>
<br />
<li class="in"><a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="Partager sur Linkedin" target="_blank">Partager sur Linkedin</a></li>
<br />
<li class="reddit"><a href="http://reddit.com/submit?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="Partager sur Reddit" target="_blank">Partager sur Reddit</a></li>
<br />
</ul>
</div>
 
<?php } ?>
<?php 



// seo plus script fin

$dynamic_widget_template = array(
		/* rename or create new dynamic sidebars */
		"galerie-photos",
		"no-sidebar",
		"ebook",
		);

	add_action("admin_init", "template_init");
	add_action('save_post', 'save_template_link');
	function template_init(){
		add_meta_box("template_meta", "S&eacute;lection mod&egrave;le article", "template_link", "post", "side", "default");
	}
	function template_link(){
		global $post, $dynamic_widget_template;
		$customer  = get_post_custom($post->ID);
		$linker    = $customer["_template"][0];
	?>
<div class="link_template_header">
	<?php
	echo '<select name="linker" class="template-selection">';
	echo '<option></option>';
	echo '<option>-----------------------</option>';
	foreach ( $dynamic_widget_template as $lister ){
		    if($linker == $lister){
		      echo '<option value="'.$lister.'" selected="true">'.$lister.'</option>';
			}else{
		      echo '<option value="'.$lister.'">'.$lister.'</option>';
			}
		}
	echo '</select><br />';
	?>
</div>
<?php
}
function save_template_link(){
global $post;
if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {return $post->ID;}
	update_post_meta($post->ID, "_template", $_POST["linker"]);
}
add_action('admin_head', 'template_css');
function template_css() {
	echo'
	<style type="text/css">
		.template-selection{width:100%;}
	</style>
	';
}


// sidebar multiple

    $dynamic_widget_areas = array(
		/* rename or create new dynamic sidebars */
		"Sidebar-2",
		"Sidebar-3",
		"Sidebar-4",
		"Sidebar-5",
		
		);


	add_action("admin_init", "sidebar_init");
	add_action('save_post', 'save_sidebar_link');
	function sidebar_init(){
		add_meta_box("sidebar_meta", "S&eacute;lection Colonne lat&eacute;rale", "sidebar_link", "page", "side", "default");
		add_meta_box("sidebar_meta", "S&eacute;lection Colonne lat&eacute;rale", "sidebar_link", "post", "side", "default");
	}
	function sidebar_link(){
		global $post, $dynamic_widget_areas;
		$custom  = get_post_custom($post->ID);
		$link    = $custom["_sidebar"][0];
	?>
<div class="link_header">
	<?php
	echo '<select name="link" class="sidebar-selection">';
	echo '<option></option>';
	echo '<option>-----------------------</option>';
	foreach ( $dynamic_widget_areas as $list ){
		    if($link == $list){
		      echo '<option value="'.$list.'" selected="true">'.$list.'</option>';
			}else{
		      echo '<option value="'.$list.'">'.$list.'</option>';
			}
		}
	echo '</select><br />';
	?>
</div>
<?php
}
function save_sidebar_link(){
global $post;
if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {return $post->ID;}
	update_post_meta($post->ID, "_sidebar", $_POST["link"]);
}
add_action('admin_head', 'sidebar_css');
function sidebar_css() {
	echo'
	<style type="text/css">
		.sidebar-selection{width:100%;}
	</style>
	';
}

// Gallerie photo class
add_filter('the_content', 'addprettyphotorel', 12);
add_filter('get_comment_text', 'addprettyphotorel');
function addprettyphotorel ($content) {   
global $post;
    $pattern = "/<a(.*?)href=('|\")([^>]*).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>(.*?)<\/a>/i";
    $replacement = '<a$1href=$2$3.$4$5 rel="prettyphoto['.$post->ID.']"$6>$7</a>';
    $content = preg_replace($pattern, $replacement, $content);
    return $content;
}

// gallerie css
add_filter('gallery_style',
	create_function(
		'$css',
		'return preg_replace("#<style type=\'text/css\'>(.*?)</style>#s", "", $css);'
		)
	);
	
	
function catch_that_image() {
global $post, $posts;
$first_img = '';
ob_start();
ob_end_clean();
$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
$first_img = $matches [1] [0];
// Si zero image
if(empty($first_img)){
$first_img = "";
}
$first_img = gallery_first_image($first_img);
return $first_img;

}

	
function gallery_first_image(){		

	global $post;

	$args = array(
		'post_type'   => 'attachment',
		'numberposts' => 1,
		'post_parent' => $post->ID,
		'order' => 'ASC',
		'orderby' => 'menu_order',
		'post_mime_type' => 'image'
		);

	$attachments = get_posts( $args );

	if ( $attachments )
	{
		foreach ( $attachments as $attachment )
		{
			return wp_get_attachment_url( $attachment->ID );
		}
	}
	return false;
}

/***********************************************************************
Fil d'ariane
***********************************************************************/
 
function wp_bac_breadcrumb() {
            $delimiter = '<span class="delimiter"> &raquo; </span>';
    $delimiter1 = '<span class="delimiter1"> &bull; </span>';
            $main = 'Accueil';
            $maxLength= 30;
    $arc_year = get_the_time('Y');
    $arc_month = get_the_time('F');
    $arc_day = get_the_time('d');
    $arc_day_full = get_the_time('l'); 
    $url_year = get_year_link($arc_year);
    $url_month = get_month_link($arc_year,$arc_month);
    if (!is_front_page()) {
        echo '<div class="breadcrumb">';
        global $post, $cat;
        $homeLink = get_option('home'); 
        echo '<a href="' . $homeLink . '">' . $main . '</a>' . $delimiter;   

        if (is_single()) { 
            $category = get_the_category();
            $num_cat = count($category); 
            if ($num_cat <=1)  
            {
                //echo get_category_parents($category[0],  true,' ' . $delimiter . ' ');
                echo ' ' . get_the_title();
            }
            else {
          
                echo the_category( $delimiter1, multiple);
                    if (strlen(get_the_title()) >= $maxLength) { 
                        echo ' ' . $delimiter . trim(substr(get_the_title(), 0, $maxLength)) . ' ...';
                    }
                    else { 
                        echo ' ' . $delimiter . get_the_title();
                    }
            }
        }
        elseif (is_category()) { 
          
            echo 'Archive pour la cat&egrave;gorie: "' . get_category_parents($cat, true,' ' . $delimiter . ' ') . '"' ;
        }
        elseif ( is_tag() ) { 

            echo 'Article : "' . single_tag_title("", false) . '"';
        }
        elseif ( is_day()) { 
            echo '<a href="' . $url_year . '">' . $arc_year . '</a> ' . $delimiter . ' ';
            echo '<a href="' . $url_month . '">' . $arc_month . '</a> ' . $delimiter . $arc_day . ' (' . $arc_day_full . ')';
        }
        elseif ( is_month() ) {  
            echo '<a href="' . $url_year . '">' . $arc_year . '</a> ' . $delimiter . $arc_month;
        }
        elseif ( is_year() ) {  
            echo $arc_year;
        }
        elseif ( is_search() ) {
            echo 'R&eacute;sultats de la recherche: "' . get_search_query() . '"';
        }
        elseif ( is_page() && !$post->post_parent ) { 
            echo get_the_title();
        }
        elseif ( is_page() && $post->post_parent ) {  
            $post_array = get_post_ancestors($post);
            krsort($post_array);
            foreach($post_array as $key=>$postid){
                $post_ids = get_post($postid);
                $title = $post_ids->post_title;       
                echo '<a href="' . get_permalink($post_ids) . '">' . $title . '</a>' . $delimiter;
            }
            the_title();
        }
        elseif ( is_author() ) {
            global $author;
            $user_info = get_userdata($author);
            echo  'Article archiv&eacute;(s) par auteur: ' . $user_info->display_name ;
        }
        elseif ( is_404() ) {
            echo  'Error 404 - Not Found.';
        }
        else {
        }
       echo '</div>';
    }
}

// commentlist

function mytheme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
     <div id="comment-<?php comment_ID(); ?>">
      <div class="vcard">
         <?php echo get_avatar($comment,$size='62',$default='<path_to_url>' ); ?>
        <div class="data-comments">
       <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>">
              <?php comment_date('j F,Y'); ?>
          </a>
          <?php edit_comment_link(__('(Edit)'),'  ','') ?>
  </div> 
	 </div>
     
      <?php if ($comment->comment_approved == '0') : ?>
         <em><?php _e('Your comment is awaiting moderation.') ?></em>
         <br />
      <?php endif; ?>
 
  <div class="comment-meta commentmetadata">
   <?php printf(__('<cite>%s</cite> <span class="says">Dit:</span>'), get_comment_author_link()) ?>
        
      </div>
    <div class="comment-txt"> <?php comment_text() ?></div>
      
      <div class="reply">
         <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
      </div>
     </div>
<?php
        }
?>
<?php
// Widget

include_once (TEMPLATEPATH . '/functions/widgets/gallery-metabox.php'); // Activating widget gallery
include_once (TEMPLATEPATH . '/functions/widgets/simplicy-post-view.php'); // Activating widget simplicy post
include_once (TEMPLATEPATH . '/functions/widgets/socials_profile.php'); // Activating widget socials profile
include_once (TEMPLATEPATH . '/functions/widgets/sd_tabs.php'); // Activating widget sidebar tabs
include_once (TEMPLATEPATH . '/functions/widgets/wp-fb-fan-box.php'); // Activating widget sidebar tabs
include_once (TEMPLATEPATH . '/functions/widgets/page-options.php'); // option page



// link page
include_once (TEMPLATEPATH . '/functions/link_page.php'); // Activating unlink parent page
// paypal
include_once (TEMPLATEPATH . '/api_pay/pay_option.php'); // Activating paypal
// custom post type
include_once (TEMPLATEPATH . '/functions/custom_post.php'); // custom post type
// Shortcode
include_once (TEMPLATEPATH . '/functions/shortcode.php'); // Activating Shortcode
// function theme

include_once (TEMPLATEPATH . '/functions/pub_box.php'); // gestion des publicit

// shortcode access Membre
add_shortcode( 'membre', 'member_check_shortcode' );
function member_check_shortcode( $atts, $content = null ) {
if ( is_user_logged_in() && !is_null( $content ) && !is_feed() )
return do_shortcode($content);
return '<div class="member-page">

<table width="635" align="center" border="1">
  <tr>
    <th style=" text-align:center;" scope="col"><h1>Vous devez &ecirc;tre membre pour continuer.</h1></th>
  </tr>
  <tr>
    <td><div class="member-btn"><a href="http://laprevention.be/login-connect/">Se connecter</a></div></td>
  </tr>
  <tr>
    <td><div class="member-btn-2"><a href="http://laprevention.be/inscription/">Devenir membre</a></div>(Inscription gratuite)</td>
  </tr>
</table>
</div>';
}
// ebook shortcode
add_shortcode('ebook', array('ebook_shortcode', 'shortcode'));
class ebook_shortcode {
    function shortcode($atts, $content=null) {
          extract(shortcode_atts(array(
               'url'      => '',
          ), $atts));
          
     return '<a href="'.$url.'?iframe=true&amp;width=100%&amp;height=100%" rel="prettyPhoto[iframe]">' . do_shortcode($content) . '</a>
				';
  }
}
function insert_attachment($file_handler,$post_id,$setthumb='false') {
// check to make sure its a successful upload
if ($_FILES[$file_handler]['error'] !== UPLOAD_ERR_OK) __return_false();
require_once(ABSPATH . "wp-admin" . '/includes/image.php');
require_once(ABSPATH . "wp-admin" . '/includes/file.php');
require_once(ABSPATH . "wp-admin" . '/includes/media.php');
$attach_id = media_handle_upload( $file_handler, $post_id );
if ($setthumb) update_post_meta($post_id,'_thumbnail_id',$attach_id);
return $attach_id;
}

add_filter('single_template', 'check_for_category_single_template');
function check_for_category_single_template( $t )
{
  foreach( (array) get_the_category() as $cat ) 
  { 
    if ( file_exists(TEMPLATEPATH . "/single-category-{$cat->slug}.php") ) return TEMPLATEPATH . "/single-category-{$cat->slug}.php"; 
    if($cat->parent)
    {
      $cat = get_the_category_by_ID( $cat->parent );
      if ( file_exists(TEMPLATEPATH . "/single-category-{$cat->slug}.php") ) return TEMPLATEPATH . "/single-category-{$cat->slug}.php";
    }
  } 
  return $t;
}



add_action('draft_post', 'send_my_mail_on_draft' );
function send_my_mail_on_draft( $post_id,$post){
   $post_title = get_the_title( $post_id );
   $post_url = get_permalink( $post_id );
   $subject = 'Une annonce est en attente de validation';

   $message = "Une nouvelle annonce est en attente de validation:\n\n";
   $message .= "" .$post_title. "\n\n";

   //send email to admin
   wp_mail( 'info@bucoweb.be', $subject, $message );
}

?>