<?php

// page
?>
<?php
$prefix = 'dbt_';
$meta_box_post = array(
	'id' => 'seo-options-post',
	'title' => 'SEO Options Post',
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
	
	array(
			'name' => '(SEO Title) Titre avec mots cl&eacute;s ',
			'desc' => 'Entrer le Titre de votre article avec un ou deux Mots-cl&eacute;s.',
			'id' => $prefix . 'title',
			'type' => 'text',
			'std' => ''
		),
		array(
			'name' => '<em>(Meta keywords)</em> Mots Cl&eacute;(s)',
			'desc' => 'Entrer les mots cl&eacute;s pour cette page s&eacute;par&eacute; par des virgules.',
			'id' => $prefix . 'keys',
			'type' => 'text2',
			'std' => ''
		),
		
		array(
			'name' => '<em>(Meta description)</em> description',
			'desc' => 'Entrer la description pour cette page.',
			'id' => $prefix . 'description',
			'type' => 'textarea',
			'std' => ''
		),
		
		
		array(
			'name' => 'Meta Robots Index',
			'desc' => '<strong>index</strong> : autorise l&acute;indexation de la page - <strong>noindex</strong> : interdit l&acute;indexation de la page.',
			'id' => $prefix . 'index',
			'std' => 'Index',
			'type' => 'radio',
			'options' => array(
				array('name' => 'Index', 'value' => 'index'),
				array('name' => 'Noindex', 'value' => 'noindex')
			)),
		
		array(
			'name' => 'Meta Robots Follow ',
			'desc' => '<strong>follow</strong> : autorise le robot &agrave; suivre les liens de la page - <strong>nofollow</strong> : interdit au robot de suivre les liens de la page.',
			'id' => $prefix . 'follow',
			'std' => 'Follow',
			'type' => 'radio',
			'options' => array(
				array('name' => 'Follow', 'value' => 'follow'),
				array('name' => 'Nofollow', 'value' => 'nofollow')
			)
			
			
	))
);

add_action('admin_menu', 'seo_post_add_box');

// Add meta box
function seo_post_add_box() {
	global $meta_box_post;
	
	add_meta_box($meta_box_post['id'], $meta_box_post['title'], 'seo_post_show_box', $meta_box_post['page'], $meta_box_post['context'], $meta_box_post['priority']);
	add_meta_box($meta_box_post['id'], $meta_box_post['title'], 'seo_post_show_box', 'page', $meta_box_post['context'], $meta_box_post['priority']);
}

// Callback function to show fields in meta box
function seo_post_show_box() {
	global $meta_box_post, $post;
	
	// Use nonce for verification
	echo '<input type="hidden" name="seo_post_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
	
	echo '<table class="form-table">';

	foreach ($meta_box_post['fields'] as $field) {
		// get current post meta data
		$meta = get_post_meta($post->ID, $field['id'], true);
		
		
		echo '<tr>',
				'<th style="width:20%"><label for="', $field['id'], '">', $field['name'], '</label></th>',
				'<td>';
		switch ($field['type']) {
		
			case 'text2':
				echo $field['desc'];
				echo '<input type="text" name="', $field['id'], '" id="message1" value="', $meta ? $meta : $field['std'], '" size="30" style="width:97%" />',
					'<br>';
				break;
			case 'text':  
				echo $field['desc'];
				echo '<br><input type="text" name="', $field['id'], '" id="message1" value="', $meta ? $meta : $field['std'], '" size="30" style="width:97%" onKeyPress="return charLimit(this)" onKeyUp="return characterCount(this)" />',
					'<br><p class="seo-infos"><span class="counter" id="charCount"></span> Caract&egrave;res restants. Id&eacute;al : <strong>60</strong> caract&egrave;res. Maximum : <strong>100</strong> caract&egrave;res.</p>
		<br>';
				break;
			case 'textarea':
				echo $field['desc'];
				echo '<textarea name="', $field['id'], '" id="message2" cols="60" rows="4" style="width:97%" onKeyPress="return charLimit2(this)" onKeyUp="return characterCount2(this)">', $meta ? $meta : $field['std'], '</textarea>',
					'<br><p class="seo-infos"><span class="counter" id="charCount2"></span> Caract&egrave;res restants. Id&eacute;al : <strong>156</strong> caract&egrave;res. Maximum : <strong>200</strong> caract&egrave;res.</p>
		<br>';
				break;
			case 'select':
				echo '<select name="', $field['id'], '" id="', $field['id'], '">';
				foreach ($field['options'] as $option) {
					echo '<option', $meta == $option ? ' selected="selected"' : '', '>', $option, '</option>';
				}
				echo '</select>';
				break;
			case 'radio':
					echo $field['desc'];
					echo '<br>' ;
				foreach ($field['options'] as $option) {
					echo '<input type="radio" name="', $field['id'], '" value="', $option['value'], '"', $meta == $option['value'] ?  ' checked="checked"' : '', ' />', $option['name'] ;
					
				}
				break;
			case 'checkbox':
				echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />';
				break;
		}
		echo 	'<td>',
			'</tr>';
	}
	
	echo '</table>';
}

add_action('save_post', 'seo_post_save_data');

// Save data from meta box
function seo_post_save_data($post_id) {
	global $meta_box_post;
	
	// verify nonce
	if (!wp_verify_nonce($_POST['seo_post_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	}

	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ('post' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}
	
	foreach ($meta_box_post['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}
}
?>