<?php
/*
Plugin video widget
*/ 


//action to initiate widgets
add_action('widgets_init', 'load_video_sidebar_widgets');


//function to register Video Sidebar Widget and Random Video Sidebar Widget
function load_video_sidebar_widgets() {
register_widget('VideoSidebarWidget');
}


//Video Sidebar Widget Class to extend WP_Widget class
class VideoSidebarWidget extends WP_Widget {

		//function to set up widget in admin
		function VideoSidebarWidget() {
		
				$widget_ops = array( 'classname' => 'videosidebar', 
				'description' => __('Un widget vid&eacute;o pour afficher la vid&eacute;o dans la barre latérale de divers r&eacute;seaux de partage de vid&eacute;os', 'videosidebar') );
				
				$control_ops = array( 'width' => 200, 'height' => 350, 'id_base' => 'videosidebar' );
				$this->WP_Widget( 'videosidebar', __('Video Widget', 'videosidebar'), $widget_ops, $control_ops );
		
		}


		//function to echo out widget on sidebar
		function widget( $args, $instance ) {
		extract( $args );
		
				$title2 = apply_filters('widget_title2', $instance['title2'] );
		        $cap2 = $instance['v_cap2'];
				
				echo $before_widget;
		
				// if user written title echo out
				if ( $title2 ){
				echo $before_title . $title2 . $after_title;
				}
			
				//get settings from Widget Admin Form to assign to function VSWShowVideo
				$autoplaysetting = $instance['v_autoplay2'];
				$videoid = $instance['v_id2'];
				$videosource = $instance['v_source']; 
				$videowidth = $instance['v_width2'];
				$videoheight = $instance['v_height2'];
				
				//function to show video in blog sidebar, please look for it below
				VSWShowVideo($videosource,$videoid,$autoplaysetting,$videowidth,$videoheight,'false','false');
				
				if($cap2){
				echo "<div class=\"videocaption\">$cap2</div>";
				}	
		
				echo $after_widget;
		
		}//end of function widget



		//function to update widget setting
		function update( $new_instance, $old_instance ) {
		
				$instance = $old_instance;
				$instance['title2'] = strip_tags( $new_instance['title2'] );
				$instance['v_width2'] = strip_tags( $new_instance['v_width2'] );
				$instance['v_height2'] = strip_tags( $new_instance['v_height2'] );
				$instance['v_autoplay2'] = strip_tags( $new_instance['v_autoplay2'] );
				$instance['v_id2'] = strip_tags( $new_instance['v_id2'] );
				$instance['v_source'] = strip_tags( $new_instance['v_source'] );
				$instance['v_cap2'] = $new_instance['v_cap2'];
				return $instance;
		
		}//end of function update


		//function to create Widget Admin form
		function form($instance) {
		
				$instance = wp_parse_args( (array) $instance, array( 'title2' => '', 'v_width2' => '', 'v_height2' => '', 
				'v_autoplay2' => '','v_id2' => '','v_source' => '','v_cap2' => '') );
				
				$instance['title2'] = strip_tags( $instance['title2'] );
				$instance['v_width2'] = strip_tags( $instance['v_width2'] );
				$instance['v_height2'] = strip_tags( $instance['v_height2'] );
				$instance['v_autoplay2'] = strip_tags( $instance['v_autoplay2'] );
				$instance['v_id2'] = strip_tags( $instance['v_id2'] );
				$instance['v_source'] = strip_tags( $instance['v_source'] );
				$instance['v_cap2'] = $instance['v_cap2'];	
				
				//function to show video in widget admin form fixed width and height, please look for it below
				$autoplaysetting = '0';
				$videoid = $instance['v_id2'];
				$videosource = $instance['v_source']; 
				$videowidth = null;
				$videoheight = null;
				//$admin = true // to show video in admin
				
				VSWShowVideo($videosource,$videoid,$autoplaysetting,$videowidth,$videoheight,'true','false');
						
				?>
				
						
				<p>
				<label for="<?php echo $this->get_field_id('title2'); ?>">Titre de votre Widget:</label> 
				<input class="widefat" id="<?php echo $this->get_field_id('title2'); ?>" name="<?php echo $this->get_field_name('title2'); ?>"
				 type="text" value="<?php echo $instance['title2']; ?>" />
				</p>
				
				<p>
				<label for="<?php echo $this->get_field_id( 'v_source' ); ?>">Selection de la source de la video:</label> 
				<select id="<?php echo $this->get_field_id( 'v_source' );?>" name="<?php echo $this->get_field_name( 'v_source' );?>" 
				class="widefat" style="width:100%;">
				<option value='YouTube' <?php  if($instance['v_source'] == 'YouTube'){echo 'selected="selected"';}?> >YouTube Video</option>
				<option value='Vimeo' <?php  if($instance['v_source'] == 'Vimeo'){echo 'selected="selected"';}?> >Vimeo Video</option>
				<option value='MySpace' <?php  if($instance['v_source'] == 'MySpace'){echo 'selected="selected"';}?> >MySpace Video</option>
				<option value='Veoh' <?php  if($instance['v_source'] == 'Veoh'){echo 'selected="selected"';}?> >Veoh Video</option>
				<option value='Blip' <?php  if($instance['v_source'] == 'Blip'){echo 'selected="selected"';}?> >blip.tv Video</option>
				<option value='WordPress' <?php  if($instance['v_source'] == 'WordPress'){echo 'selected="selected"';}?> >WordPress Video
                </option>
				<option value='Viddler' <?php  if($instance['v_source'] == 'Viddler'){echo 'selected="selected"';}?> >Viddler Video</option>
				<option value='DailyMotion' <?php  if($instance['v_source'] == 'DailyMotion'){echo 'selected="selected"';}?> >DailyMotion Video                </option>
				<option value='Revver' <?php  if($instance['v_source'] == 'Revver'){echo 'selected="selected"';}?> >Revver Video</option>
				<option value='Metacafe' <?php  if($instance['v_source'] == 'Metacafe'){echo 'selected="selected"';}?> >Metacafe Video</option>
				<option value='Tudou' <?php  if($instance['v_source'] == 'Tudou'){echo 'selected="selected"';}?> >Tudou Video</option>
				<option value='Youku' <?php  if($instance['v_source'] == 'Youku'){echo 'selected="selected"';}?> >Youku Video</option>
				<option value='cn6' <?php  if($instance['v_source'] == 'cn6'){echo 'selected="selected"';}?> >6.cn Video</option>
				<option value='Google' <?php  if($instance['v_source'] == 'Google'){echo 'selected="selected"';}?> >Google Video</option>
                <option value='Tangle' <?php  if($instance['v_source'] == 'Tangle'){echo 'selected="selected"';}?> >Tangle Video</option>
				</select>
				</p>
				
				<p>
				<label for="<?php echo $this->get_field_id('v_id2'); ?>">ID de la video: </label>
				<input class="widefat" id="<?php echo $this->get_field_id('v_id2'); ?>" 
                name="<?php echo $this->get_field_name('v_id2'); ?>" type="text" value="<?php echo $instance['v_id2']; ?>" /></p>
				
				<p>
				<label for="<?php echo $this->get_field_id('v_width2'); ?>">Largeur de la video:<br /> <em>(en px)</em> </label>
				<input class="widefat" id="<?php echo $this->get_field_id('v_width2'); ?>" 
                name="<?php echo $this->get_field_name('v_width2'); ?>" type="text" value="<?php echo $instance['v_width2']; ?>" />
				</p>
				
				<p>
				<label for="<?php echo $this->get_field_id('v_height2'); ?>">Hauteur de la video:<br /> <em>(en px)</em>  </label>
				<input class="widefat" id="<?php echo $this->get_field_id('v_height2'); ?>" 
                name="<?php echo $this->get_field_name('v_height2'); ?>" type="text" value="<?php echo $instance['v_height2']; ?>" />
				</p>
				
                <p>
				<label for="<?php echo $this->get_field_id('v_cap2'); ?>">Commentaire sur la Video: </label>
				<input class="widefat" id="<?php echo $this->get_field_id('v_cap2'); ?>" 
                name="<?php echo $this->get_field_name('v_cap2'); ?>" type="text" value="<?php echo $instance['v_cap2']; ?>" />
				</p>
                
                
				<p>
				
				<?php
				
				// check whether autoplay feature supported by video network
				$source = $instance['v_source']; 
				$msg = "<p>D&eacute;sol&eacute;, l&acute;option de lecture automatique n&acute;est pas pris en charge par ".$source."</p>";
				switch ($source) {
						
						case WordPress:
						echo $msg;
						break;
						
						case Tudou:
						echo $msg;
						break;
						
						case Youku:
						echo $msg;
						break;
						
						case Blip:
						echo "<p>D&eacute;sol&eacute;, l&acute;option de lecture automatique supprim&eacute;e car elle est &agrave; l&acute;origine d&acute;erreur dans Internet Explorer</p>";
						break;
						
						case cn6:
						echo "<p>D&eacute;sol&eacute;, l&acute;option de lecture automatique n&acute;est pas pris en charge par 6.cn</p>";
						break;
					}	
				
				?>
				
				<label for="<?php echo $this->get_field_id( 'v_autoplay2' ); ?>">Lecture Auto:</label> 
				<select id="<?php echo $this->get_field_id( 'v_autoplay2' );?>" 
                name="<?php echo $this->get_field_name( 'v_autoplay2' );?>" class="widefat" style="width:100%;">';
				<option value='1' <?php  if($instance['v_autoplay2'] == '1'){echo 'selected="selected"';}?>>Oui</option>
				<option value='0' <?php  if($instance['v_autoplay2'] == '0'){echo 'selected="selected"';}?>>Non</option>
				</select>
				</p>
				
				<?php
		
	      }//end of function form($instance)

}//end of Video Sidebar Widget Class



function VSWShowVideo($videosource,$videoid,$autoplaysetting,$videowidth,$videoheight,$admin,$shortcode){

//admin = true to show in widget admin
//admin = false to show in blog sidebar

        $v_autoplay2 = $autoplaysetting;
        $v_id2 = $videoid;
		$v_source = $videosource;		
        $v_width2 = $videowidth;
        $v_height2 = $videoheight;
  
      	$source = $v_source;
        
		//test for source and assign codes accordingly	
		switch ($source) {
		
		case null:
		$value = null;
		$flashvar = null;
		$flashvar2 = null;
		break;		
		
        case YouTube:
        $value = "http://www.youtube.com/v/$v_id2&autoplay=$v_autoplay2&loop=0&rel=0";
		$flashvar = null;
		$flashvar2 = null;
        break;
		
		case Vimeo:
		$value =  "http://vimeo.com/moogaloop.swf?clip_id=$v_id2&amp;server=vimeo.com&amp;loop=0&amp;fullscreen=1&amp;autoplay=$v_autoplay2";
		$flashvar = null;
		$flashvar2 = null;
        break;
		
		case MySpace:
		$value =  "http://mediaservices.myspace.com/services/media/embed.aspx/m=$v_id2,t=1,mt=video,ap=$v_autoplay2";
		$flashvar = null;
		$flashvar2 = null;
        break;
		
		case Veoh:
		$value = "http://www.veoh.com/static/swf/webplayer/WebPlayer.swf?version=AFrontend.5.4.2.20.1002&";
		$value.= "permalinkId=$v_id2&player=videodetailsembedded&id=anonymous&videoAutoPlay=$v_autoplay2";
		$flashvar = null;
		$flashvar2 = null;
        break;
		
	    case Blip:
		$value =  "http://blip.tv/play/$v_id2";
		$flashvar = null;
		$flashvar2 = null;
        break;
		
	    case WordPress:
		$value =  "http://v.wordpress.com/$v_id2";
		$flashvar = null;
		$flashvar2 = null;
        break;
		
		case Viddler:
		$value =  "http://www.viddler.com/player/$v_id2";
		if($v_autoplay2=='1'){
		$flashvar = "<param name=\"flashvars\" value=\"autoplay=t\" />\n";
		$flashvar2 = 'flashvars="autoplay=t" ';
		}
        break;
		
		case DailyMotion:
		$value =  "http://www.dailymotion.com/swf/$v_id2&autoStart=$v_autoplay2&related=0";
		$flashvar = null;
		$flashvar2 = null;
        break;
				
		
		case Revver:
		$value = "http://flash.revver.com/player/1.0/player.swf?mediaId=$v_id2&autoStart=$v_autoplay2";
		$flashvar = null;
		$flashvar2 = null;
		break;
		
		case Metacafe:
		$id = split('/',$v_id2);
		$value = "http://www.metacafe.com/fplayer/$id[0]/$id[1].swf";
		if($v_autoplay2=='1'){
		$flashvar = null;
		$flashvar2 = 'flashVars="playerVars=showStats=no|autoPlay=yes|"';
		}
		break;
		
		case Tudou:
		$value = "$v_id2";
		$flashvar = null;
		$flashvar2 = null;
		break;
		
		case Youku:
		$value = "$v_id2";
		$flashvar = null;
		$flashvar2 = null;
		break;
		
		case cn6:
		$value = "$v_id2";
		$flashvar = null;
		$flashvar2 = null;
		break;
		
		case Google:
		$value = "http://video.google.com/googleplayer.swf?docid=$v_id2&hl=en&fs=true";
		if($v_autoplay2=='1'){
		$flashvar = null;
		$flashvar2 = 'FlashVars="autoPlay=true&playerMode=embedded"';
		}
		break;
		
		case Tangle:
		$value = "http://www.tangle.com/flash/swf/flvplayer.swf";
		if($v_autoplay2=='1'){
		$flashvar = null;
		$flashvar2 = "FlashVars=\"viewkey=$v_id2&autoplay=$v_autoplay2\"";
		}else{
		$flashvar = null;
		$flashvar2 = "FlashVars=\"viewkey=$v_id2\"";
		}
		break;
	
		}
		
		if($shortcode=="true"){
		//added in version 2.3
		//return instead of echo video on blog using shortcode
		$vsw_code = "\n<object width=\"$v_width2\" height=\"$v_height2\">\n";
		$vsw_code .= $flashvar;
		$vsw_code .= "<param name=\"allowfullscreen\" value=\"true\" />\n";
		$vsw_code .= "<param name=\"allowscriptaccess\" value=\"always\" />\n";
		$vsw_code .= "<param name=\"movie\" value=\"$value\" />\n";
		$vsw_code .= "<param name=\"wmode\" value=\"transparent\">\n";
		$vsw_code .= "<embed src=\"$value\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" ";
		$vsw_code .= "allowfullscreen=\"true\" allowscriptaccess=\"always\" ";
		$vsw_code .= $flashvar2;
		$vsw_code .= "width=\"$v_width2\" height=\"$v_height2\">\n";
		$vsw_code .= "</embed>\n";
		$vsw_code .= "</object>\n\n";
		return $vsw_code;
		}
		elseif($admin=="true"){
		// echo video in admin
        echo "\n<object width=\"212\" height=\"172\">\n";
		echo $flashvar;
		echo "<param name=\"allowfullscreen\" value=\"true\" />\n";
		echo "<param name=\"allowscriptaccess\" value=\"always\" />\n";
		echo "<param name=\"movie\" value=\"$value\" />\n";
		echo "<param name=\"wmode\" value=\"transparent\">\n";
		echo "<embed src=\"$value\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" ";
		echo "allowfullscreen=\"true\" allowscriptaccess=\"always\" ";
		echo $flashvar2;
		echo "width=\"212\" height=\"172\">\n";
		echo "</embed>\n";
		echo "</object>\n\n";

        }else{
		
		// echo video on blog
		echo "\n<object width=\"$v_width2\" height=\"$v_height2\">\n";
		echo $flashvar;
		echo "<param name=\"allowfullscreen\" value=\"true\" />\n";
		echo "<param name=\"allowscriptaccess\" value=\"always\" />\n";
		echo "<param name=\"movie\" value=\"$value\" />\n";
		echo "<param name=\"wmode\" value=\"transparent\">\n";
		echo "<embed src=\"$value\" type=\"application/x-shockwave-flash\" wmode=\"transparent\" ";
		echo "allowfullscreen=\"true\" allowscriptaccess=\"always\" ";
		echo $flashvar2;
		echo "width=\"$v_width2\" height=\"$v_height2\">\n";
		echo "</embed>\n";
		echo "</object>\n\n";
		}


}//end of function VSWShowVideo












//sdded in version 2.3
//create shortcode to use WP_WIDGET class to echo out video 
//[vsw id="123456" source="vimeo" width="400" height="300" autoplay="no"]
function vsw_show_video($atts, $content = null) {
	extract(shortcode_atts(array(
	    "id" => ' ',
		"source" => ' ',
		"width" => ' ',
		"height" => ' ',
		"autoplay" => ' ',
	), $atts));
	
return vsw_show_video_class($id,$source,$width,$height,$autoplay);
}

add_shortcode("vsw", "vsw_show_video");

//function to be used in shortcode or directly in theme
//uses the_widget WordPress Function found in widgets.php
function vsw_show_video_class($id,$source,$width,$height,$autoplay){

        $vsw_id = $id;
		$vsw_width = $width;
		$vsw_height = $height;
        
		//convert string of source to lowercase
        $source = strtolower($source);

        //should have used all lowercase in previous functions
		//now have to switch it.
		switch ($source) {
		
		case null:
		$vsw_source = null;
		break;
		
		case youtube:
		$vsw_source = YouTube;
		break;
		
		case vimeo:
		$vsw_source = Vimeo;
        break;
		
		case myspace:
		$vsw_source = MySpace;
        break;
		
		case veoh:
		$vsw_source = Veoh;
        break;
		
	    case bliptv:
		$vsw_source = Blip;
        break;
		
	    case wordpress:
		$vsw_source = WordPress;
        break;
		
		case viddler:
		$vsw_source = Viddler;
        break;
		
		case dailymotion:
		$vsw_source = DailyMotion;
        break;
				
		
		case revver:
		$vsw_source = Revver;
		break;
		
		case metacafe:
		$vsw_source = Metacafe;
		break;
		
		case tudou:
		$vsw_source = Tudou;
		break;
		
		case youku:
		$vsw_source = Youku;
		break;
		
		case cn6:
		$vsw_source = cn6;
		break;
		
		case google:
		$vsw_source = Google;
		break;
		
		case tangle:
		$vsw_source = Tangle;
		break; 
		
		}
		
		//string to lowercase
		$autoplay = strtolower($autoplay);
		
		//switch autoplay yes or no to 1 or 0
		switch ($autoplay) {
		
		case null:
		$vsw_autoplay = 0;
		break;
		
		case no:
		$vsw_autoplay = 0;
		break;
		
		case yes:
		$vsw_autoplay = 1;
		break;
		
		}
			
	
$vsw_code = VSWShowVideo($vsw_source,$vsw_id,$vsw_autoplay,$vsw_width,$vsw_height,'false','true');

return $vsw_code;

}

//add tinymce button to editor
function dd_vsw_addbuttons() {
   // Don't bother doing this stuff if the current user lacks permissions
   if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
     return;
 
   // Add only in Rich Editor mode
   if ( get_user_option('rich_editing') == 'true') {
     add_filter("mce_external_plugins", "dd_vsw_tinymce_plugin");
     add_filter('mce_buttons', 'dd_vsw_button');
   }
}
 
function dd_vsw_button($tiny_buttons) {
   array_push($tiny_buttons, "vsw");
   return $tiny_buttons;
}

// determine absolute url path of editor_plugin.js
function dd_vsw_plugin_url() {
 
    //repertoire de l'éditeur js 
	return "../../../wp-content/themes/simplicypress_2_prevention/functions/video_widget/editor_plugin.js";
	
	}


// Load the TinyMCE plugin : editor_plugin.js (wp2.5)
function dd_vsw_tinymce_plugin($plugin_array) {
   $path = dd_vsw_plugin_url("video-sidebar-widgets");
   $plugin_array['vsw'] = $path;
   return $plugin_array;
}
 
// init process for button control
add_action('init', 'dd_vsw_addbuttons');



?>
