<?php
/*
	Plugin Name: Social profile widget
	Plugin URI: http://www.naxialis.com/
	Description: 
	Author: naxialis
	Author URI: http://www.naxialis.com/

	Version: 1.2

	License: GNU General Public License v2.0
	License URI: http://www.opensource.org/licenses/gpl-license.php

	NOTE: This plugin is released under the GPLv2 license. The images packaged with this plugin are the property
	of their respective owners, and do not, necessarily, inherit the GPLv2 license.
*/

/**
 * Register the Widget
 */
add_action('widgets_init', 'social_profiles_widget_register');
function social_profiles_widget_register() {
	register_widget('Social_Profiles_Widget');
}

/**
 * The Widget Class
 */
if ( !class_exists('Social_Profiles_Widget') ) {
class Social_Profiles_Widget extends WP_Widget {

	function Social_Profiles_Widget() {
		$widget_ops = array( 'classname' => 'social-profiles', 'description' => __('Affiche les liens sociaux de votre profil', 'spw') );
		$this->WP_Widget( 'socialprofiles', __('Social Profiles', 'spw'), $widget_ops );
	}

	var $plugin_imgs_url;

	function spw_fields_array( $instance = array() ) {

		$this->plugins_imgs_url = content_url().'/themes/simplicypress_2_prevention/images/socials/';

		return array(
			'feedburner' => array(
				'title' => __('RSS/Feedburner URL', 'spw'),
				'img' => sprintf( '%s/Feed_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Feed_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('RSS', 'spw')
			),
			'google' => array(
				'title' => __('Google Plus URL', 'spw'),
				'img' => sprintf( '%s/Google_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Google_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('Google', 'spw')
			),

			'twitter' => array(
				'title' => __('Twitter URL', 'spw'),
				'img' => sprintf( '%s/Twitter_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Twitter_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('Twitter', 'spw')
			),
			'facebook' => array(
				'title' => __('Facebook URL', 'spw'),
				'img' => sprintf( '%s/Facebook_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Facebook_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('Facebook', 'spw')
			),
			'linkedin' => array(
				'title' => __('Linkedin URL', 'spw'),
				'img' => sprintf( '%s/Linkedin_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Linkedin_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('Linkedin', 'spw')
			),
			'youtube' => array(
				'title' => __('YouTube URL', 'spw'),
				'img' => sprintf( '%s/Youtube_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Youtube_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('Youtube', 'spw')
			),
			'flickr' => array(
				'title' => __('Flickr URL', 'spw'),
				'img' => sprintf( '%s/Flickr_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Flickr_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('Flickr', 'spw')
			),
			'delicious' => array(
				'title' => __('Delicious URL', 'spw'),
				'img' => sprintf( '%s/Delicious_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Delicious_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('Delicious', 'spw')
			),
			'stumbleupon' => array(
				'title' => __('StumbleUpon URL', 'spw'),
				'img' => sprintf( '%s/Stumbleupon_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Stumbleupon_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('StumbleUpon', 'spw')
			),
			'digg' => array(
				'title' => __('Digg URL', 'spw'),
				'img' => sprintf( '%s/Digg_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), esc_attr( $instance['size'] ) ),
				'img_widget' => sprintf( '%s/Digg_%s.png', $this->plugins_imgs_url . esc_attr( $instance['icon_set'] ), '48x48' ),
				'img_title' => __('Digg', 'spw')
			),
		);
	}

	function widget($args, $instance) {

		extract($args);

		$instance = wp_parse_args($instance, array(
			'title' => '',
			'new_window' => 0,
			'icon_set' => 'default',
			'size' => '24x24'
		) );

		echo $before_widget;

			if ( ! empty( $instance['title'] ) )
				echo $before_title . $instance['title'] . $after_title;
				
			$new_window = $instance['new_window'] ? 'target="_blank"' : '';

			foreach ( $this->spw_fields_array( $instance ) as $key => $data ) {
				if ( ! empty ( $instance[$key] ) ) {
					printf( '<a href="%s" %s><img class="profile-social" src="%s" alt="%s" /></a>', esc_url( $instance[$key] ), $new_window, esc_url( $data['img'] ), esc_attr( $data['img_title'] ) );
				}
			}

		echo $after_widget;

	}

	function update($new_instance, $old_instance) {
		return $new_instance;
	}

	function form($instance) {

		$instance = wp_parse_args($instance, array(
			'title' => '',
			'new_window' => 0,
			'icon_set' => 'default',
			'size' => '24x24'
		) );
?>

		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title', 'spw'); ?>:</label><br />
			<input id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $instance['title']; ?>" style="width:95%;" />
		</p>
		
		<p><label><input id="<?php echo $this->get_field_id( 'new_window' ); ?>" type="checkbox" name="<?php echo $this->get_field_name( 'new_window' ); ?>" value="1" <?php checked( 1, $instance['new_window'] ); ?>/> <?php esc_html_e( 'Ouvrir le lien dans une nouvelle fen&ecirc;tre ?', 'spw' ); ?></label></p>

		<p>
			<label for="<?php echo $this->get_field_id('icon_set'); ?>"><?php _e('Icon Set', 'spw'); ?>:</label>
			<select id="<?php echo $this->get_field_id('icon_set'); ?>" name="<?php echo $this->get_field_name('icon_set'); ?>">
				<option style="padding-right:10px;" value="default" <?php selected('default', $instance['icon_set']); ?>><?php _e('Defaut', 'spw'); ?></option>
				<option style="padding-right:10px;" value="circles" <?php selected('circles', $instance['icon_set']); ?>><?php _e('Cercles', 'spw'); ?></option>
			</select>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('size'); ?>"><?php _e('Icon Size', 'spw'); ?>:</label>
			<select id="<?php echo $this->get_field_id('size'); ?>" name="<?php echo $this->get_field_name('size'); ?>">
				<option style="padding-right:10px;" value="24x24" <?php selected('24x24', $instance['size']); ?>><?php _e('Mini', 'spw'); ?> (24px)</option>
				<option style="padding-right:10px;" value="32x32" <?php selected('32x32', $instance['size']); ?>><?php _e('Moyen', 'spw'); ?> (32px)</option>
				<option style="padding-right:10px;" value="48x48" <?php selected('48x48', $instance['size']); ?>><?php _e('Grand', 'spw'); ?> (48px)</option>
			</select>
		</p>

		<p><?php _e('Entrez l&acute;URL (s) pour vos diff&eacute;rents profiles sociaux ci-dessous. Si vous laissez un champ vide profil de l&acute;URL, il ne sera pas utilis&eacute;.', 'spw'); ?></p>

<?php

		foreach ( $this->spw_fields_array( $instance ) as $key => $data ) {
			echo '<p>';
			printf( '<img style="float: left; margin-right: 5px;" src="%s" title="%s" />', $data['img_widget'], $data['img_title'] );
			printf( '<label for="%s"> %s:</label>', esc_attr( $this->get_field_id($key) ), esc_attr( $data['title'] ) );
			printf( '<input id="%s" name="%s" value="%s" style="%s" />', esc_attr( $this->get_field_id($key) ), esc_attr( $this->get_field_name($key) ), esc_url( $instance[$key] ), 'width:65%;' );
			echo '</p>' . "\n";
		}

	}
}}