<?php
/**
 * Plugin Name: Widget eBook
 * Plugin URI: 
 * Description: 
 * Version: 0.1
 * Author: naxialis
 * Author URI: 
 *
 */

/**
 * Add function to widgets_init that'll load our widget.
 * @since 0.1
 */
add_action( 'widgets_init', 'book_load_widgets' );

/**
 * Register our widget.
 * 'book_Widget' is the widget class used below.
 *
 * @since 0.1
 */
function book_load_widgets() {
	register_widget( 'book_Widget' );
}

/**
 * Example Widget class.
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 * @since 0.1
 */
class book_Widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function book_Widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'book', 'description' => __('Affiche lien pour le eBook.', 'book') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'book-widget' );

		/* Create the widget. */
		$this->WP_Widget( 'book-widget', __('eBook', 'book'), $widget_ops, $control_ops );
	}

	/**
	 * How to display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$lien = $instance['lien'];
		$txt_alt = $instance['txt_alt'];
		$lien_img = $instance['lien_img'];

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $title )
			echo $before_title . $title . $after_title;

		/* Display name from widget settings if one was input. */
		
		/* affichage du lien. */
		if ( $lien )
			printf( '<ul style="text-align:center;"><a href="' . $lien. '"><img src="'.$lien_img.' "/></a><br />
			'.$txt_alt .'
			</ul>'
			
 );
	
		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['lien'] = strip_tags( $new_instance['lien'] );
		$instance['txt_alt'] = strip_tags( $new_instance['txt_alt'] );
		$instance['lien_img'] = strip_tags( $new_instance['lien_img'] );

		return $instance;
	}

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array( 'title' => __('eBook', 'book'));
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'hybrid'); ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />
            <label for="<?php echo $this->get_field_id( 'lien_img' ); ?>"><?php _e('Lien de l&acute;icon :', 'hybrid'); ?></label>
            <input id="<?php echo $this->get_field_id( 'lien_img' ); ?>" name="<?php echo $this->get_field_name( 'lien_img' ); ?>" value="<?php echo $instance['lien_img']; ?>" style="width:100%;" />
            <label for="<?php echo $this->get_field_id( 'lien' ); ?>"><?php _e('Lien de la page :', 'hybrid'); ?></label>
            <input id="<?php echo $this->get_field_id( 'lien' ); ?>" name="<?php echo $this->get_field_name( 'lien' ); ?>" value="<?php echo $instance['lien']; ?>" style="width:100%;" />
            <label for="<?php echo $this->get_field_id( 'txt_alt' ); ?>"><?php _e('Texte :', 'hybrid'); ?></label>
            <input id="<?php echo $this->get_field_id( 'txt_alt' ); ?>" name="<?php echo $this->get_field_name( 'txt_alt' ); ?>" value="<?php echo $instance['txt_alt']; ?>" style="width:100%;" />
		</p>


	<?php
	}
}

?>