<?php
/*
Plugin Name: Smart Form
Plugin URI: http://www.naxialis.com
Description: Formulaire de contact HTML5 avec validation du formulaire, et anti-spam.
Version: Version: 1.0
Author: fred
Author URI: http://www.naxialis.com
*/


$plugin_dir =  ABSPATH . 'wp-content/plugins/smartform/';
if(file_exists($plugin_dir.WPLANG.'.php')) include_once($plugin_dir.WPLANG.'.php');
if (!session_id()) session_start();

function message_remove_malicious($input) {
        if (empty($input)) return;
        $bad_inputs=array("\r", "mime-version", "content-type", "cc:", "to:");
        $input = str_replace($bad_inputs,"",$input);
        return $input;
    }

function __e($phrase) {
	global $language_array,$wpdb;
	if(!is_array($language_array)) $language_array = array();
	$phrase = mysql_real_escape_string($phrase);
	if (!array_key_exists($phrase,$language_array)) {
		$translation = $phrase;
	} else {
		$translation  = $language_array[$phrase];
	}	
	return $translation;
}


function html5_form() {
	global $wpdb;
	
	$plugin_path = WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__));
	$plugin_dir =  ABSPATH . 'wp-content/plugins/smartform/';	
	$page_url = get_permalink($post->ID);
	$ip = $_SERVER['REMOTE_ADDR'];
	
	if(isset($_GET[msg])) {
		$output .= '<p icon="accept">'.__e(urldecode($_GET[msg])).'</p>';
	}
	
	//Process form
	if(isset($_POST[submit])) {
		
		foreach($_POST as $vblname => $value) {$postcontent[$vblname] = stripslashes($value);}
		$validate = TRUE;
		preg_match('/^[a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.([a-zA-Z]{2,4})$/', $_POST['email'], $useremail);
		
		
		if($_POST['captcha'] != $_SESSION['rand_code'] OR empty($_POST['captcha'])) {
			$validate = FALSE;
			$errormsg[4] = '<span class="form-error" icon="warning">'.__e('Les lettres saisies ne correspondent pas').'</span>';		
		}		
		
		if(empty($postcontent['sender_name'])) {
			$validate = FALSE;
			$errormsg[0] = '<span class="form-error" icon="warning">'.__e('Entrez votre nom ').'</span>';		
		}
		
		if(empty($useremail)) {
			$validate = FALSE;
			if ($_POST['email']!=$useremail) {
				$errormsg[1] = '<span class="form-error" icon="warning">'.__e('Entrez une adresse email valide!').'</span>';
			} else {
				$errormsg[1] = '<span class="form-error" icon="warning">'.__e('Entrez une adresse email!').'</span>';
			}		
		}
		if(empty($postcontent['subject'])) {
			$validate = FALSE;
			$errormsg[2] = '<span class="form-error" icon="warning">'.__e('Entrez le sujet de votre Email').'</span>';		
		}
		if(empty($postcontent['message'])) {
			$validate = FALSE;
			$errormsg[3] = '<span class="form-error" icon="warning">'.__e('Entrez un message').'</span>';		
		}
		
		if($validate) {
				$recipient = get_option('scf_send_to_email');
				$name= $postcontent['sender_name'];
				$email = $postcontent['email'];
				$selected = $postcontent['selected'];
				$subject = stripslashes($postcontent['subject']);
				$msg = stripslashes($postcontent['message']);
				$headers = "MIME-Version: 1.0\r\n";
				$headers .= "From: ".$name." <".$email.">\r\n";
				$headers .= "Content-Type: text/plain; charset=\"".get_settings('blog_charset')."\"\r\n";
				$fullmsg = __e('Expediteur ').': '.$name." <".$email.">\n\n";
				$fullmsg .= __e('Demande ').': '.$selected."\n\n";
				$fullmsg .= __e('Sujet ').': '.$subject."\n\n";
				$fullmsg .= wordwrap($msg, 80, "\n")."\n\n";
				$fullmsg .= "IP: ".$_SERVER['REMOTE_ADDR'];
				
				//Remove any attempt to modify headers etc
				$fullmsg = message_remove_malicious($fullmsg);
				
				$mail_success = wp_mail($recipient, get_option('scf_mail_subject'), $fullmsg, $headers);
				
				if($mail_success){
					$output .= '<div class="send-ok"><p icon="accept">'.__e('Votre message a &eacute;t&eacute; envoy&eacute;!').'</p></div>';
					unset($_POST['email']);
					unset($_POST['selected']);
					unset($_POST['sender_name']);
					unset($_POST['message']);
					unset($_POST['subject']);
					//header('Location: '.$page_url.'?msg='.urlencode('Your message was sent successfully!'));
				} else {
					$output .= '<p icon="accept">'.__e('Il y avait un probl&egrave;me d&acute;envoi de votre message, s&acute;il vous pla&icirc;t essayer de nouveau !').'</p>';
				}
				
	}	
	}
	
	$selected = isset( $values['selected'] ) ? esc_attr( $values['selected'][0] ) : '';
	$output .= '<div class="contact-contrainer">';
	//Generate form
	$output .= '<form method="POST" action="'.$page_url.'" class="contact-smart">';

	$output .= '<div class="field">
	<span class="lspan"><label for="sender_name">'.__e('Votre Nom :').'</label></span><span class="inspan"><input class="hinput" type="text" name="sender_name" value="'.$_POST['sender_name'].'"></span>
	</div><div class="error-div">'.$errormsg[0].'</div>';
	
	
	$output .= '<div class="field">
	<span class="lspan"><label for="sender_name">'.__e('Votre Email : ').'</label></span><span class="inspan"><input class="hinput" type="text" name="email" value="'.$_POST['email'].'"> </span></div><div class="error-div">'.$errormsg[1].'</div>';
	
	$output .= '<div class="field">
	<span class="lspan"><label for="subject">'.__e('Votre demande : ').'</label></span><span class="inspan">
	
<select class="hselect" name="selected">
			<option value="Affiliations&#8211;partenariats" '. selected( $_POST['selected'], 'Affiliations&#8211;partenariats' ) .'>Affiliations&#8211;partenariats</option>
			<option value="Articles&#8211;contenus du site" '. selected( $_POST['selected'], 'Articles&#8211;contenus du site' ).'>Articles&#8211;contenus du site</option>
			<option value="Comptabilite" '. selected( $_POST['selected'], 'Comptabilit&eacute;' ).'>Comptabilit&eacute;</option>
			<option value="Devis" '. selected( $_POST['selected'], 'Devis' ).'>Devis</option>
			<option value="Formations&#8211;Analyses de risques dans votre Ets" '. selected( $_POST['selected'], 'Formations&#8211;Analyses de risques dans votre Ets' ).'>Formations&#8211;Analyses de risques dans votre Ets</option>
			<option value="Inscriptions&#8211;Statut membre" '. selected( $_POST['selected'], 'Inscriptions&#8211;Statut membre' ).'>Inscriptions&#8211;Statut membre</option>
			<option value="Jobs" '. selected( $_POST['selected'], 'Jobs' ).'>Jobs</option>
			<option value="Propositions&#8211;Critiques" '. selected( $_POST['selected'], 'Propositions&#8211;Critiques' ).'>Propositions&#8211;Critiques</option>
			<option value="Autres" '. selected( $_POST['selected'], 'Autres' ).'>Autres</option>
		</select>
		
 </span></div>
	<div class="error-div">'.$errormsg[2].'</div>';
	
	$output .= '<div class="field">
	<span class="lspan"><label for="subject">'.__e('Sujet : ').'</label></span><span class="inspan"><input class="hinput" type="text" name="subject" value="'.$_POST['subject'].'"></span></div><div class="error-div">'.$errormsg[2].'</div>';

						
	$output .= '<div class="field">
	<span class="lspan"><label for="sender_name">'.__e('Message').'</label></span><br/><span class="inspan"><textarea class="htextarea" name="message">'.$_POST['message'].'</textarea></span></div><div class="error-div">'.$errormsg[3].'</div>';
	
	//Set number of letters to user with captcha
	$num_letters = get_option('scf_captcha_num_letters');
	if($num_letters<1) $num_letters = 5; //If not set by admin, set to 5
	
	$output .= '<div class="field">
	<span class="lspan"><label for="captcha">'.__e('Entrez le code :').'</label></span><input type="text" class="hinput" style="width:100px" name="captcha" value=""><span class="captcha-smart"><img src="'.$plugin_path.'captcha.php?n='.$num_letters.'" /></span></div><div class="error-div">'.$errormsg[4].'</div>';				
	
			
	$output .='<div class="field" style="margin-top:15px">
					<input type = "submit"  class="csubmit" name = "submit" value="'.__e('Envoyer').'" style="" />
				</div>';
	$output .='</form>';
	$output .= '</div>';
	return $output;
	
}

function scf_add_admin_page() {
	add_options_page('Formulaire de contact', 'Formulaire de contact', 8, __FILE__, 'wp_simple_contact_form_admin_page');
}

function wp_simple_contact_form_admin_page() { 
	$base_name = plugin_basename('useronline/useronline-options.php');
	$base_page = 'admin.php?page='.$base_name;
	
	if(!current_user_can('edit_themes')) {
		die('Access Denied');
	}
	
	if(isset($_POST[submit])) {
	 	foreach($_POST as $vblname => $value) {$postcontent[$vblname] = mysql_real_escape_string($value); }
		
		update_option('scf_send_to_email', $postcontent[send_to_email]);
		update_option('scf_captcha_num_letters', $postcontent[captcha_num_letters]);
		update_option('scf_mail_subject', $postcontent[scf_mail_subject]);
		
		$ui_feedback = 'Vos modifications ont &eacute;t&eacute; enregistrer';
	}
	
	
	?>
	
	<div class="wrap">
	<?php if(!empty($ui_feedback)) echo '<div id="message" class="updated fade"><p>'.$ui_feedback.'</p></div>'; ?>
		<h2>Formulaire de contact</h2>
			<form method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">
				<fieldset class="options">
			 		<legend></legend>
			 		<table width="50%"  border="0" cellspacing="3" cellpadding="3">
			 		
					 <tr valign="top">
						<th align="left">Ajouter votre Email</th>
						<td align="left">
							<input type="text" name="send_to_email" value="<?php echo get_option('scf_send_to_email'); ?>" size="40" />
						</td>
					</tr>

					<tr valign="top">
						<th align="left">Ent&ecirc;te de l&acute;email de reception</th>
						<td align="left">
							<input type="text" name="scf_mail_subject" value="<?php echo get_option('scf_mail_subject'); ?>" size="40" />
						</td>
					</tr>
					
					<tr valign="top">
						<th align="left">Nombre de lettres dans la capcha</th>
						<td align="left">
							<input type="text" name="captcha_num_letters" value="<?php echo get_option('scf_captcha_num_letters'); ?>" size="10" />
						</td>
					</tr>
					
					</table>
				<input type="submit" name="submit" value="Sauvegarder" />
				</fieldset>
			</form>
	<h2>Utilisation</h2>
	Pour utiliser le formulaire de contact, il suffit d&acute;ajouter une page avec le texte suivant:
	<code>[smart_form]</code>
	</div>
	
	<?php
	
}


add_action('admin_menu', 'scf_add_admin_page');

add_filter('the_content', 'place_wp_simple_contact_form', '7');

function place_wp_simple_contact_form($content){
	 $output = html5_form();
     $content = str_replace( '[smart_form]', $output, $content); 
	 return $content;
}

function writeCSS() {
	$path = WP_PLUGIN_URL.'/'.str_replace(basename( __FILE__),"",plugin_basename(__FILE__));
 	echo ( '<link rel="stylesheet" type="text/css" href="'. $path . 'form.css"> <!-- Added by the WP Simple contact form plugin --> ' ); 
}
add_action('wp_head', 'writeCSS');
?>