(function(){

    tinymce.PluginManager.requireLangPack('sp_insert_shorcodes');
    
    tinymce.create('tinymce.plugins.sp_insert_shorcodes', {
    
        init : function(ed, url){
            ed.addCommand('mceilcPHP', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[br]');
            });
            ed.addButton('lineBreak', {
                title: 'Saut de ligne',
                image: url + '/lineBreak.png',
                cmd: 'mceilcPHP'
            });
            ed.addShortcut('alt+ctrl+x', ed.getLang('Saut de ligne'), 'mceilcPHP');
			
			
			ed.addCommand('mceilcCSS', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[member]' + ilc_sel_content + '[/member]');
            });
            ed.addButton('Members', {
                title: 'Membre',
                image: url + '/members.png',
                cmd: 'mceilcCSS'
            });
            ed.addShortcut('alt+ctrl+c', ed.getLang('Membre'), 'mceilcCSS');
			
			
			// Dropcap
			ed.addCommand('dropcap', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[dropcap]' + ilc_sel_content + '[/dropcap]');
				
            });
            ed.addButton('drop', {
                title: 'Majuscule',
                image: url + '/drop1.png',
                cmd: 'dropcap'
            });
            ed.addShortcut('alt+ctrl+h', ed.getLang('Majuscule'), 'dropcap');
			
			
			// 2 colonnes
			ed.addCommand('2_cols', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[one_half] Votre Texte [/one_half]' + ilc_sel_content + '[one_half_last] Votre Texte [/one_half_last]');
				
            });
            ed.addButton('2cols', {
                title: '2 Colonnes',
                image: url + '/2cols.png',
                cmd: '2_cols'
            });
            ed.addShortcut('alt+ctrl+h', ed.getLang('2 Colonnes'), '2_cols');
			
			// 3 colonnes
			ed.addCommand('3_cols', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[one_third] Votre Texte [/one_third]' + ilc_sel_content + '[one_third] Votre Texte [/one_third]'+ ilc_sel_content + '[one_third_last] Votre Texte [/one_third_last]');
				
            });
            ed.addButton('3cols', {
                title: '3 Colonnes',
                image: url + '/2cols.png',
                cmd: '3_cols'
            });
            ed.addShortcut('alt+ctrl+h', ed.getLang('3 Colonnes'), '3_cols');
			
			// 4 colonnes
			ed.addCommand('4_cols', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[one_fourth] Votre Texte [/one_fourth]' + ilc_sel_content + '[one_fourth] Votre Texte [/one_fourth]'+ ilc_sel_content + '[one_fourth] Votre Texte [/one_fourth]'+ ilc_sel_content + '[one_fourth_last] Votre Texte [/one_fourth_last]');
				
            });
            ed.addButton('4cols', {
                title: '4 Colonnes',
                image: url + '/2cols.png',
                cmd: '4_cols'
            });
            ed.addShortcut('alt+ctrl+h', ed.getLang('4 Colonnes'), '4_cols');
			
			// 2 colonnes 1 trois quart (gauche) et une un quart 
			ed.addCommand('2_cols_1_small', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[two_third] Votre Texte [/two_third]' + ilc_sel_content + '[one_third_last] Votre Texte [/one_third_last]');
				
            });
            ed.addButton('2cols1small', {
                title: 'Une colonne trois quart (gauche)  + Une colonnes un quart',
                image: url + '/2cols.png',
                cmd: '2_cols_1_small'
            });
            ed.addShortcut('alt+ctrl+h', ed.getLang('Une colonne trois quart (gauche)  + Une colonnes un quart'), '2_cols_1_small');
			
			// 2 colonnes 1 trois quart (droite) et une un quart 
			ed.addCommand('2_cols_right_small', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[one_fourth] Votre Texte [/one_fourth]' + ilc_sel_content + '[three_fourth_last] Votre Texte [/three_fourth_last]');
				
            });
            ed.addButton('2colsrightsmall', {
                title: 'Une colonne trois quart (droite)  + Une colonnes un quart',
                image: url + '/2cols.png',
                cmd: '2_cols_right_small'
            });
            ed.addShortcut('alt+ctrl+h', ed.getLang('Une colonne trois quart (droite)  + Une colonnes un quart'), '2_cols_right_small');
			
			// Iframe
			
			ed.addCommand('iframe', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[iframe url="Votre lien ici" titre="Titre du lien"]');
            });
            ed.addButton('Iframe', {
                title: 'Iframe',
                image: url + '/iframe.png',
                cmd: 'iframe'
            });
            ed.addShortcut('alt+ctrl+c', ed.getLang('Iframe'), 'iframe');
			
			// Iframe
			
			ed.addCommand('pdf_file', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[pdf_file url="Lien du fichier PDF" titre="Titre du PDF"]');
            });
            ed.addButton('PDF', {
                title: 'PDF',
                image: url + '/pdf.png',
                cmd: 'pdf_file'
            });
            ed.addShortcut('alt+ctrl+c', ed.getLang('PDF'), 'pdf_file');
			/*
			
			ed.addCommand('mceilcJS', function(){
                ilc_sel_content = tinyMCE.activeEditor.selection.getContent();
                tinyMCE.activeEditor.selection.setContent('[js]' + ilc_sel_content + '[/js]');
            });
            ed.addButton('ilcJS', {
                title: 'sp_insert_shorcodes.js',
                image: url + '/js.png',
                cmd: 'mceilcJS'
            });
            ed.addShortcut('alt+ctrl+j', ed.getLang('sp_insert_shorcodes.js'), 'mceilcJS');
			*/
			
        },
        createControl : function(n, cm){
            return null;
        },
        getInfo : function(){
            return {
                longname: 'ILC Syntax Buttons',
                author: '@naxialis',
                authorurl: 'http://naxialis.com/',
                infourl: 'http://twitter.com/naxialis',
                version: "1.0"
            };
        }
    });
    tinymce.PluginManager.add('sp_insert_shorcodes', tinymce.plugins.sp_insert_shorcodes);
})();



