<?php
/**
 * CMB Tabbed Theme Options
 *
 * @author    Arushad Ahmed <@dash8x, contact@arushad.org>
 * @link      http://arushad.org/how-to-create-a-tabbed-options-page-for-your-wordpress-theme-using-cmb
 * @version   0.1.0
 */
class my_Admin {

    /**
     * Default Option key
     * @var string
     */
    private $key = 'site_options';

    /**
     * Array of metaboxes/fields
     * @var array
     */
    protected $option_metabox = array();

    /**
     * Options Page title
     * @var string
     */
    protected $title = '';

    /**
     * Options Tab Pages
     * @var array
     */
    protected $options_pages = array();

    /**
     * Constructor
     * @since 0.1.0
     */
    public function __construct() {
        // Set our title
        $this->title = __( 'Theme Options', 'theme_textdomain' );
    }

    /**
     * Initiate our hooks
     * @since 0.1.0
     */
    public function hooks() {
        add_action( 'admin_init', array( $this, 'init' ) );
        add_action( 'admin_menu', array( $this, 'add_options_page' ) ); //create tab pages
    }

    /**
     * Register our setting tabs to WP
     * @since  0.1.0
     */
    public function init() {
    	$option_tabs = self::option_fields();
        foreach ($option_tabs as $index => $option_tab) {
        	register_setting( $option_tab['id'], $option_tab['id'] );
        }
    }

    /**
     * Add menu options page
     * @since 0.1.0
     */
    public function add_options_page() {        
        $option_tabs = self::option_fields();
        foreach ($option_tabs as $index => $option_tab) {
        	if ( $index == 0) {
        		$this->options_pages[] = add_menu_page( $this->title, $this->title, 'manage_options', $option_tab['id'], array( $this, 'admin_page_display' ) ); //Link admin menu to first tab
        		add_submenu_page( $option_tabs[0]['id'], $this->title, $option_tab['title'], 'manage_options', $option_tab['id'], array( $this, 'admin_page_display' ) ); //Duplicate menu link for first submenu page
        	} else {
        		$this->options_pages[] = add_submenu_page( $option_tabs[0]['id'], $this->title, $option_tab['title'], 'manage_options', $option_tab['id'], array( $this, 'admin_page_display' ) );
        	}
        }
    }

    /**
     * Admin page markup. Mostly handled by CMB
     * @since  0.1.0
     */
    public function admin_page_display() {
    	$option_tabs = self::option_fields(); //get all option tabs
    	$tab_forms = array();     	   	
        ?>
        <div class="wrap cmb_options_page <?php echo $this->key; ?>">        	
            <h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
            
            <!-- Options Page Nav Tabs -->           
            <h2 class="nav-tab-wrapper">
            	<?php foreach ($option_tabs as $option_tab) :
            		$tab_slug = $option_tab['id'];
            		$nav_class = 'nav-tab';
            		if ( $tab_slug == $_GET['page'] ) {
            			$nav_class .= ' nav-tab-active'; //add active class to current tab
            			$tab_forms[] = $option_tab; //add current tab to forms to be rendered
            		}
            	?>            	
            	<a class="<?php echo $nav_class; ?>" href="<?php menu_page_url( $tab_slug ); ?>"><?php esc_attr_e($option_tab['title']); ?></a>
            	<?php endforeach; ?>
            </h2>
            <!-- End of Nav Tabs -->

            <?php foreach ($tab_forms as $tab_form) : //render all tab forms (normaly just 1 form) ?>
            <div id="<?php esc_attr_e($tab_form['id']); ?>" class="group">
            	<?php cmb2_metabox_form( $tab_form, $tab_form['id'] ); ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php
    }

    /**
     * Defines the theme option metabox and field configuration
     * @since  0.1.0
     * @return array
     */
    public function option_fields() {

        // Only need to initiate the array once per page-load
        if ( ! empty( $this->option_metabox ) ) {
            return $this->option_metabox;
        }        

        $this->option_metabox[] = array(
            'id'         => 'general_options', //id used as tab page slug, must be unique
            'title'      => 'General Options',
            'show_on'    => array( 'key' => 'options-page', 'value' => array( 'general_options' ), ), //value must be same as id
            'show_names' => true,
            'fields'     => array(
			
				array(
					'name' => __('Favicon', 'theme_textdomain'),
					'desc' => __('Site favicon. (32x32)', 'theme_textdomain'),
					'id' => 'favicon',
					'default' => '',
					'type' => 'file',
				),
				array(
					'name' => __( 'Google analytics', 'cmb2' ),
					'desc' => __('Vous devez ajouter le code <strong>UA-xxxxxx-x</strong> de compte Google Analytics.', 'theme_textdomain'),
					'id'   => 'google_analytics',
					'type' => 'text',
    			
				),	
			
			)
        );		

		$this->option_metabox[] = array(
            'id'         => 'inscriptions_options', //id used as tab page slug, must be unique
            'title'      => 'Options Inscription',
            'show_on'    => array( 'key' => 'options-page', 'value' => array( 'general_options' ), ), //value must be same as id
            'show_names' => true,
            'fields'     => array(
				array(
					'name' => __( 'Inscriptions URL', 'cmb2' ),
					'id'   => 'url_inscription',
					'type' => 'text_url',
    				// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
				),		
				array(
					'name' => __( 'Mots de passe oublié URL', 'cmb2' ),
					'id'   => 'password_url',
					'type' => 'text_url',
    				// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
				),
				
				array(
					'name' => __( 'Url de redirection pour après inscription', 'cmb2' ),
					'id'   => 'redirect_inscription_url',
					'type' => 'text_url',
    				// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
				),				
				array(
					'name' => __( 'Url de redirection pour les conditions générales', 'cmb2' ),
					'id'   => 'condition_url',
					'type' => 'text_url',
    				// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
				),
				array(
					'name' => __( 'Url de redirection pour les informations', 'cmb2' ),
					'id'   => 'info_url',
					'type' => 'text_url',
    				// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
				),		
				array(
					'name' => __( 'Url page menbre', 'cmb2' ),
					'id'   => 'account_url',
					'type' => 'text_url',
    				// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
				),
				
				array(
					'name' => __( 'Url page souscription premium', 'cmb2' ),
					'id'   => 'premium_url',
					'type' => 'text_url',
    				// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
				),
				
						
			)
        );		
		
		$this->option_metabox[] = array(
            'id'         => 'paiement_options', //id used as tab page slug, must be unique
            'title'      => 'Options paiement',
            'show_on'    => array( 'key' => 'options-page', 'value' => array( 'general_options' ), ), //value must be same as id
            'show_names' => true,
            'fields'     => array(
			
				array(
					'name' => __( 'Adresse email pour la confirmation de la page abonnement premium', 'cmb2' ),
					'id'   => 'mail_inscription',
					'type' => 'text',
    				// 'protocols' => array( 'http', 'https', 'ftp', 'ftps', 'mailto', 'news', 'irc', 'gopher', 'nntp', 'feed', 'telnet' ), // Array of allowed protocols
				),	
			
				array(
					'name' => __('Versement Bancaire', 'theme_textdomain'),
					'desc' => __('', 'theme_textdomain'),
					'id' => 'iban_paiement',
					'default' => '',				
					'type' => 'textarea',
				),
				array(
					'name' => __('Service', 'theme_textdomain'),
					'desc' => __('', 'theme_textdomain'),
					'id' => 'service',
					'default' => 'Adhésion',					
					'type' => 'text'
				),
				
				array(
					'name' => __('Prix ht', 'theme_textdomain'),
					'desc' => __('', 'theme_textdomain'),
					'id' => 'prix',
					'default' => '36,00',					
					'type' => 'text'
				),
				
				array(
					'name' => __('TVA', 'theme_textdomain'),
					'desc' => __('', 'theme_textdomain'),
					'id' => 'tva',
					'default' => '21',					
					'type' => 'text'
				),
			)
        );		

        $this->option_metabox[] = array(
            'id'         => 'social_options',
            'title'      => 'Social Media Settings',
            'show_on'    => array( 'key' => 'options-page', 'value' => array( 'social_options' ), ),
            'show_names' => true,
            'fields'     => array(
				array(
					'name' => __('Facebook Username', 'theme_textdomain'),
					'desc' => __('Username of Facebook page.', 'theme_textdomain'),
					'id' => 'facebook',
					'default' => '',					
					'type' => 'text'
				),
				array(
					'name' => __('Twitter Username', 'theme_textdomain'),
					'desc' => __('Username of Twitter profile.', 'theme_textdomain'),
					'id' => 'twitter',
					'default' => '',					
					'type' => 'text'
				),
				array(
					'name' => __('Youtube Username', 'theme_textdomain'),
					'desc' => __('Username of Youtube channel.', 'theme_textdomain'),
					'id' => 'youtube',
					'default' => '',					
					'type' => 'text'
				),
				array(
					'name' => __('Flickr Username', 'theme_textdomain'),
					'desc' => __('Username of Flickr profile.', 'theme_textdomain'),
					'id' => 'flickr',
					'default' => '',					
					'type' => 'text'
				),
				array(
					'name' => __('Google+ Profile ID', 'theme_textdomain'),
					'desc' => __('ID of Google+ profile.', 'theme_textdomain'),
					'id' => 'google_plus',
					'default' => '',					
					'type' => 'text'
				),
			)
        );

        $this->option_metabox[] = array(
            'id'         => 'advanced_options',
            'title'      => 'Advanced Settings',
            'show_on'    => array( 'key' => 'options-page', 'value' => array( 'advanced_options' ), ),
            'show_names' => true,
            'fields'     => array(
            	array(
					'name' => __('Nombre d&acute;article dans le slideshow', 'theme_textdomain'),
					'desc' => __('', 'theme_textdomain'),
					'id' => 'slide_nb_post',
					'default' => '',					
					'type' => 'text'
				),
				
				array(
					'name' => __('identifiant numérique de la catégorie a afficher dans le slideshow', 'theme_textdomain'),
					'desc' => __('', 'theme_textdomain'),
					'id' => 'slide_cat_post',
					'default' => '',					
					'type' => 'text'
				),
				array(
					'name' => __('Custom CSS', 'theme_textdomain'),
					'desc' => __('Enter any custom CSS you want here.', 'theme_textdomain'),
					'id' => 'new_custom_css',
					'default' => '',				
					'type' => 'textarea',
				),
			)
        );
        
        //insert extra tabs here

        return $this->option_metabox;
    }

    /**
     * Returns the option key for a given field id
     * @since  0.1.0
     * @return array
     */
    public function get_option_key($field_id) {
    	$option_tabs = $this->option_fields();
    	foreach ($option_tabs as $option_tab) { //search all tabs
    		foreach ($option_tab['fields'] as $field) { //search all fields
    			if ($field['id'] == $field_id) {
    				return $option_tab['id'];
    			}
    		}
    	}
    	return $this->key; //return default key if field id not found
    }

    /**
     * Public getter method for retrieving protected/private variables
     * @since  0.1.0
     * @param  string  $field Field to retrieve
     * @return mixed          Field value or exception is thrown
     */
    public function __get( $field ) {

        // Allowed fields to retrieve
        if ( in_array( $field, array( 'key', 'fields', 'title', 'options_pages' ), true ) ) {
            return $this->{$field};
        }
        if ( 'option_metabox' === $field ) {
            return $this->option_fields();
        }

        throw new Exception( 'Invalid property: ' . $field );
    }

}

// Get it started
$my_Admin = new my_Admin();
$my_Admin->hooks();

/**
 * Wrapper function around cmb_get_option
 * @since  0.1.0
 * @param  string  $key Options array key
 * @return mixed        Option value
 */
function site_option( $key = '' ) {
    global $my_Admin;
    return cmb2_get_option( $my_Admin->get_option_key($key), $key );
}

?>