<?php
/**
 * @package WordPress
 * @subpackage naxialis
 */

// Do not delete these lines
	if (isset($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');
	
	if ( post_password_required() ) { ?>
		<p class="nocomments"><?php _e('Cet article est protégé par un mot de passe. Entrez le mot de passe pour acc&eacute;der aux commentaires.'); ?></p> 
	<?php
		return;
	}
?>

<!-- You can start editing here. -->

<?php if ( have_comments() ) : ?>
	<h3 class="title-comment"><?php comments_number(__('Aucun commentaire'), __('Un Commentaire'), __('% Commenataires'));?> <?php printf(__('pour &#8220;%s&#8221;'), the_title('', '', false)); ?></h3>

	<div class="navigation">
		<div class="alignleft"><?php previous_comments_link() ?></div>
		<div class="alignright"><?php next_comments_link() ?></div>
	</div>

	<ol class="commentlist">
	<?php wp_list_comments(array('avatar_size' => '55', 'type' => 'comment')); ?>
	</ol>

	<div class="navigation">
		<div class="alignleft"><?php previous_comments_link() ?></div>
		<div class="alignright"><?php next_comments_link() ?></div>
	</div>
 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->

	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<p class="nocomments"><?php _e('Les commentaires sont ferm&eacute;s.'); ?></p>

	<?php endif; ?>
<?php endif; ?>


<?php if ( comments_open() ) : ?>

<div id="respond">

<h3 class="title-comment"><?php comment_form_title( __('Laisser un commentaire'), __('Laisser un commentaire pour %s') ); ?></h3>

<div id="cancel-comment-reply"> 
	<small><?php cancel_comment_reply_link() ?></small>
</div> 

<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
<p><?php printf(__('Vous devez &ecirc;tre <a href="%s">connect&eacute;</a> pour d&eacute;poser un commentaire.'), wp_login_url( get_permalink() )); ?></p>
<?php else : ?>
<div id="comment-form-1">
<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ( is_user_logged_in() ) : ?>

<p><?php printf(__('Connect&eacute; en tant que <a href="%1$s">%2$s</a>.'), get_option('siteurl') . '/wp-admin/profile.php', $user_identity); ?> <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('Ce d&eacute;connectez'); ?>"><?php _e('Déconnexion &raquo;'); ?></a></p>

<?php else : ?>

<p>
<label for="author"><small><?php _e('Nom'); ?> <?php if ($req) _e("(*)"); ?></small></label>
<input type="text" class="wp_input" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>"  tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> />
</p>

<p>
<label for="email"><small><?php _e('Mail (ne sera pas publi&eacute;)'); ?> <?php if ($req) _e("(*)"); ?></small></label>
<input type="text" class="wp_input" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>"  tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> />
</p>

<p>
<label for="url"><small><?php _e('Site Web'); ?></small></label>
<input type="text"  class="wp_input" name="url" id="url" value="<?php echo  esc_attr($comment_author_url); ?>"  tabindex="3" />
</p>

<?php endif; ?>



<p><textarea name="comment" class="wp_textarea" id="comment" cols="58" rows="10" tabindex="4"></textarea></p>
<p><?php printf(__('<strong>XHTML:</strong> Vous pouvez utiliser ces balises : <code>%s</code>'), allowed_tags()); ?></p>
<p class="comment-submit"><input name="submit" type="submit" id="submit" tabindex="5" value="<?php _e('Envoyer'); ?>" />
<?php comment_id_fields(); ?> 
</p>
<?php do_action('comment_form', $post->ID); ?>

</form>
</div>
<?php endif; // If registration required and not logged in ?>
</div>

<?php endif; // if you delete this the sky will fall on your head ?>