<?php
function faq_toggle( $atts, $content = null ) {
 extract( shortcode_atts(
 array(
 'title' => 'Click To Open',
 'color' => 'dark'
 ),
 $atts ) );
 return '<h3 class="trigger toggle-'.$color.'"><a href="#">'. $title .'</a></h3><div class="toggle_container">' . do_shortcode($content) . '</div>';
 }
 add_shortcode('faq-toggle', 'faq_toggle');
 
 // Add scripts to wp_head()
function child_theme_head_script() {
	echo '<style>
	
h3.trigger {
    
    margin-top: 0 !important;
    font-weight:400;
    font-size: 16px;
    padding: 10px;
    padding-left: 32px;
    
}
h3.trigger:before {
	padding-left: 0;
	margin-left:-23px;
	margin-top: 15px !important;
	position:absolute;
	content: "\f502";
		display: inline-block;
		-webkit-font-smoothing: antialiased;
		font: normal 18px/1 "Genericons";
		vertical-align: top;
    
}
h3.trigger a {
    color: #333;
    text-decoration: none;
    display: block;
	
	
}
h3.trigger a:hover {
    color: #0489B7;
    text-decoration: underline;
}
h3.active:before{
	margin-top: 5px !important;
  content: "\f500";
		display: inline-block;
		-webkit-font-smoothing: antialiased;
		font: normal 18px/1 "Genericons";
		vertical-align: top;
}
h3.toggle-white{
    background-color: #FFF;
}
h3.toggle-gray{
    background-color: #F5F5F5;
}
h3.toggle-dark{
    background-color:#383838;
	color:#fff; 
}
h3.toggle-dark a{
    color:#fff; 
}
.toggle_container {
    overflow: hidden;
    padding: 20px 40px;
}
	
	</style>';
    
	echo '<script>
	jQuery(function($){
    $(document).ready(function(){ 
         $(".toggle_container").hide();
         $("h3.trigger").click(function(){
        $(this).toggleClass("active").next().slideToggle("normal");
        return false; //Prevent the browser jump to the link anchor
    });
    });
});</script>';
}
add_action( 'wp_head', 'child_theme_head_script' );