<?php
/*
Custom post type la prevention.be
*/ 
add_action('init', 'custom_pub_register');  
  
function custom_pub_register() {  
    $args = array(  
        'label' => __('Publicités'),  
        'singular_label' => __('Publicités'),  
        'public' => true,  
        'show_ui' => true,  
        'capability_type' => 'post',  
        'hierarchical' => false,  
        'rewrite' => true,  
        'supports' => array('title', 'editor', 'thumbnail')  
       );  
  
    register_post_type( 'publicite' , $args ); 
	flush_rewrite_rules(); 
}  

register_taxonomy("pub-type", array("publicite"), array("hierarchical" => true, "label" => "Pub cat&eacute;gories", "singular_label" => "Pub cat&eacute;gories", "rewrite" => true));

add_action("admin_init", "publicite_meta_box");   


function publicite_meta_box(){  
    add_meta_box("projInfo-meta", "Publicités Options", "publicite_meta_options", "publicite", "side", "low");  
}  
  

function publicite_meta_options(){  
        global $post;  
        if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) return $post_id;
        $custom = get_post_custom($post->ID);  
        $link = $custom["projLink"][0];  
?>  
    <label>Link:</label><input name="projLink" value="<?php echo $link; ?>" />  
<?php  
    }  
    
add_action('save_post', 'save_project_link'); 
  
function save_project_link(){  
    global $post;  
    
    if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){ 
		return $post_id;
	}else{
    	update_post_meta($post->ID, "projLink", $_POST["projLink"]); 
    } 
}  

add_filter("manage_edit-publicite_columns", "project_edit_columns");   
  
function project_edit_columns($columns){  
        $columns = array(  
            "cb" => "<input type=\"checkbox\" />",  
            "title" => "Publicités",  
            "description" => "Description",  
            "link" => "Lien",  
            "type" => "Type de Publicités ",  
        );  
  
        return $columns;  
}  

add_action("manage_posts_custom_column",  "project_custom_columns"); 
  
function project_custom_columns($column){  
        global $post;  
        switch ($column)  
        {  
            case "description":  
                the_excerpt();  
                break;  
            case "link":  
                $custom = get_post_custom();  
                echo $custom["projLink"][0];  
                break;  
            case "type":  
                echo get_the_term_list($post->ID, 'pub-type', '', ', ','');  
                break;  
        }  
}  
?>