<?php
/*
link page custom by naxialis
*/
add_filter('wp_list_pages', 'wp_list_pages_unlink_parents', 0, 2);

/**
 * Bas sur wp_list_pages de wp-includes/post-template.php
 */
function wp_list_pages_unlink_parents($output, $r) {
	$output = '';
	$current_page = 0;

	$pages = get_pages($r);

	if ( !empty($pages) ) {
		if ( $r['title_li'] )
			$output .= '<li class="pagenav">' . $r['title_li'] . '<ul>';

		$r['walker'] = new Walker_Page_Unlink_Parents;
			
		global $wp_query;
		if ( is_page() || is_attachment() || $wp_query->is_posts_page )
			$current_page = $wp_query->get_queried_object_id();
		$output .= walk_page_tree($pages, $r['depth'], $current_page, $r);

		if ( $r['title_li'] )
			$output .= '</ul></li>';
	}

	return $output;
}

/**
 *  HTML list pages
 * Bas sur Walker_Page class de wp-includes/post-template.php
 *
 *  Walker
 */
class Walker_Page_Unlink_Parents extends Walker {

	var $tree_type = 'page';

	var $db_fields = array ('parent' => 'post_parent', 'id' => 'ID');
	
	// Define six new member variables to hold the option settings, and the list of all page objects
	var $option_dummy = 1;
	
	var $option_unlink_current = 0;

	var $option_remove_titles = 0;

	var $option_maxdepth = 9999;
	
	var $option_unlink_array = array();
	
	var $all_pages = array();

	// Dfinition d'un constructeur pour charger les paramtres de l'option de la DB, et d'initialiser la liste objet de la page.
	function Walker_Page_Unlink_Parents() {
		$unlink_options = get_option('ambrosite_unlink_parents');

		$this->option_dummy = is_null($unlink_options['dummy']) ? 1 : $unlink_options['dummy'];
		$this->option_unlink_current = $unlink_options['unlink_current'];
		$this->option_remove_titles = $unlink_options['remove_titles'];
		$this->option_maxdepth = ( $unlink_options['maxdepth'] ) ? $unlink_options['maxdepth'] : 9999;
		if ( $unlink_options['expages'] )
			$this->option_unlink_array = array_map( 'intval', explode(',', $unlink_options['expages']) );

		$all_pages_wp_query = new WP_Query();
		$this->all_pages = $all_pages_wp_query->query( array('post_type' => 'page', 'posts_per_page' => -1) );
	}

	function start_lvl(&$output, $depth) {
		$indent = str_repeat("\t", $depth);
		$output .= "\n$indent<ul>\n";
	}

	function end_lvl(&$output, $depth) {
		$indent = str_repeat("\t", $depth);
		$output .= "$indent</ul>\n";
	}

	// This is the only method that has been modified from the core Walker_Page class.
	function start_el(&$output, $page, $depth, $args, $current_page) {
		if ( $depth )
			$indent = str_repeat("\t", $depth);
		else
			$indent = '';

		extract($args, EXTR_SKIP);

		$unlink_current = false;
		$css_class = array('page_item', 'page-item-'.$page->ID);
		if ( !empty($current_page) ) {
			$_current_page = get_page( $current_page );
			if ( isset($_current_page->ancestors) && in_array($page->ID, (array) $_current_page->ancestors) )
				$css_class[] = 'current_page_ancestor';
			if ( $page->ID == $current_page ) {
				$css_class[] = 'current_page_item';
				if ( $this->option_unlink_current )
					$unlink_current = true;
			}
			elseif ( $_current_page && $page->ID == $_current_page->post_parent )
				$css_class[] = 'current_page_parent';
		} elseif ( $page->ID == get_option('page_for_posts') ) {
			$css_class[] = 'current_page_parent';
		}

		$css_class = implode(' ', apply_filters('page_css_class', $css_class, $page));
		
//		Code modifi. Trouver toutes les pages de l'enfant, et si elles existent, dissocier la page parent (si  une profondeur infrieure  maxdepth).
		$page_children = get_page_children($page->ID, $this->all_pages);

		$link_open = '<a href="' . get_page_link($page->ID) . '"';
		$link_close = '</a>';
		if ( !empty($page_children) && $depth < $this->option_maxdepth || in_array($page->ID, $this->option_unlink_array) || $unlink_current ) {
			if ( $this->option_dummy ) {
				$link_open = '<a href="javascript:void(0)" style="cursor: pointer;" onclick="return false"';
			} else {
				$link_open = '<span';
				$link_close = '</span>';
			}
		}

		$page_title = ( $this->option_remove_titles ) ? '' : ' title="' . esc_attr(apply_filters('the_title', $page->post_title)) . '"';

		$output .= $indent . '<li class="' . $css_class . '">' . $link_open . $page_title . '>' . $link_before . apply_filters('the_title', $page->post_title) . $link_after . $link_close;
//		Fin du code modifier.

		if ( !empty($show_date) ) {
			if ( 'modified' == $show_date )
				$time = $page->post_modified;
			else
				$time = $page->post_date;

			$output .= " " . mysql2date($date_format, $time);
		}
	}

	function end_el(&$output, $page, $depth) {
		$output .= "</li>\n";
	}

}
?>