<?php
/*
Gallery manager
/**
 * Naxialis
 *
 */
function be_gallery_metabox( $post ) {

} 
?>
<?php
$prefix = 'gallery_';

$meta_box_gallery = array(
	'id' => 'gallery-meta-box',
	'title' => 'Param&egrave;tre de la gallerie wordpress',
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
	
	array(
			
			'desc' => 'Pour afficher la galerie photos s&eacute;lectionner le mod&egrave;le galerie-photo dans la colonne lat&eacute;rale.<br />
Exemple de configuration :<br />
Largeur de la galerie <strong>520px</strong> taille des vignettes <strong>150px</strong> positionnement : <strong>none</strong><br />
Largeur de la galerie <strong>220px</strong> taille des vignettes <strong>80px</strong> positionnement : <strong>left</strong><br />
',
			'type' => 'description',
			
		),
		array(
			'name' => 'Taille des Vignettes',
			'desc' => 'Entrer la taille des vignettes en px(<em>exemple: 150px</em>), la hauteur et largeur sont proportionnelle.',
			'id' => $prefix . 'size',
			'type' => 'text',
			'std' => '150px'
		),
		array(
			'name' => 'Largeur de la galerie',
			'desc' => 'Entrer la lageur de votre gallerie en px(<em>exemple : 450px</em>).',
			'id' => $prefix . 'width',
			'type' => 'text',
			'std' => ''
		),
		
		array(
			'name' => 'Positionnement',
			'desc' => '<strong>Left</strong> = A gauche - <strong>Right</strong> = A droite - <strong>None</strong> = Au centre.',
			'id' => $prefix . 'position',
			'type' => 'select',
			'options' => array('left', 'right', 'none')
		),
	
	)
);

add_action('admin_menu', 'gallery_add_box');

// Add meta box
function gallery_add_box() {
	global $meta_box_gallery;
	
	add_meta_box($meta_box_gallery['id'], $meta_box_gallery['title'], 'gallery_show_box', $meta_box_gallery['page'], $meta_box_gallery['context'], $meta_box_gallery['priority']);
	add_meta_box($meta_box_gallery['id'], $meta_box_gallery['title'], 'gallery_show_box', 'page', $meta_box_gallery['context'], $meta_box_gallery['priority']);
	
}

// Callback function to show fields in meta box
function gallery_show_box() {
	global $meta_box_gallery, $post;
	
	// Use nonce for verification
	echo '<input type="hidden" name="mytheme_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
	
	echo '<table class="form-table">';

	foreach ($meta_box_gallery['fields'] as $field) {
		// get current post meta data
		$meta = get_post_meta($post->ID, $field['id'], true);
		
		echo '<tr>',
				'<th style="width:20%"><label for="', $field['id'], '">', $field['name'], '</label></th>',
				'<td>';
		switch ($field['type']) {
		
		case 'description':
				echo $field['desc'];
				break;
		
			case 'text':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="10" style="width:10%" />',
					'<br />', $field['desc'];
				break;
			case 'textarea':
				echo '<textarea name="', $field['id'], '" id="', $field['id'], '" cols="60" rows="4" style="width:97%">', $meta ? $meta : $field['std'], '</textarea>',
					'<br />', $field['desc'];
				break;
			case 'select':
				echo '<select name="', $field['id'], '" id="', $field['id'], '">';
				foreach ($field['options'] as $option) {
					echo '<option', $meta == $option ? ' selected="selected"' : '', '>', $option, '</option>';
				}
				echo '</select>','<br />', $field['desc'];;
				break;
			case 'radio':
				foreach ($field['options'] as $option) {
					echo '<input type="radio" name="', $field['id'], '" value="', $option['value'], '"', $meta == $option['value'] ? ' checked="checked"' : '', ' />', $option['name'];
				}
				break;
			case 'checkbox':
				echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />';
				break;
		}
		echo 	'<td>',
			'</tr>';
	}
	
	echo '</table>';
	
	
	$args = array(
		'post_type' => 'attachment',
		'post_status' => 'inherit',
		'post_parent' => $post->ID,
		'post_mime_type' => 'image',
		'posts_per_page' => '-1',
		'order' => 'ASC',
		'orderby' => 'menu_order',
	);
	$args = apply_filters( 'be_gallery_metabox_args', $args );
	
	$intro = '<p><a href="media-upload.php?post_id=' . $post->ID .'&amp;type=image&amp;TB_iframe=1&amp;width=640&amp;height=715" id="add_image" class="thickbox" title="' . __( 'Add Image', 'gallery-metabox' ) . '">' . __( 'Envoyer des Images', 'gallery-metabox' ) . '</a> | <a href="media-upload.php?post_id=' . $post->ID .'&amp;type=image&amp;tab=gallery&amp;TB_iframe=1&amp;width=640&amp;height=715" id="manage_gallery" class="thickbox" title="' . __( 'Param&egrave;tre de la Gallerie', 'gallery-metabox' ) . '">' . __( 'Param&egrave;tre de la Gallerie', 'gallery-metabox' ) . '</a></p>';
	echo apply_filters( 'be_gallery_metabox_intro', $intro );

	
	$loop = new WP_Query( $args );
	if( !$loop->have_posts() )
		echo '<p>pas d&acute;images.</p>';
			
	while( $loop->have_posts() ): $loop->the_post(); global $post;
		$thumbnail = wp_get_attachment_image_src( $post->ID, apply_filters( 'be_gallery_metabox_image_size', 'thumbnail' ) );
		echo '<img src="' . $thumbnail[0] . '" alt="' . get_the_title() . '" /> ';
	endwhile; wp_reset_query();
}

add_action('save_post', 'gallery_save_data');

// Save data from meta box
function gallery_save_data($post_id) {
	global $meta_box_gallery;
	
	// verify nonce
	if (!wp_verify_nonce($_POST['mytheme_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	}

	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ('page' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}
	
	foreach ($meta_box_gallery['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}
}
?>