<?php
/*
Page manager
/**
 * Naxialis
 *
 */
?>
<?php
$prefix = 'pageopts_';
// Pull all the categories into an array
$options_categories = array("Aucune cat&eacute;gorie");  
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
    	$options_categories[$category->cat_ID] = $category->slug;
}
$meta_box_page_opts = array(
	'id' => 'page_opts_meta',
	'title' => 'Param&egrave;tre de la page',
	'page' => 'page',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(

		
		array(
			'name' => 'Voulez-vous affich&eacute; le titre de la page ?',
			'desc' => '<strong>index</strong> : autorise l&acute;indexation de la page - <strong>noindex</strong> : interdit l&acute;indexation de la page.',
			'id' => $prefix . 'title',
			'std' => 'Oui',
			'type' => 'radio',
			'options' => array(
				array('name' => 'Oui', 'value' => 'Oui'),
				array('name' => 'Non', 'value' => 'Non')
				
				)
			),
			
			array(
			
			'desc' => 'Utiliser les options ci-dessous pour parametrer les page template suivante :<br /> <strong>Index 1 :</strong> (<em>3 Colonnes Vertical</em>)<br /><strong>Index 2 :</strong> (<em>4 Colonnes Vertical</em>)<br /><strong>Index 3 :</strong> (<em>1 Colonne</em>). ',
			'type' => 'description',
			
		),
			
			array(
			'name' => 'Combien D&acute;article voulez-vous affich&eacute; ?',
			'desc' => '',
			'id' => $prefix . 'number_post',
			'type' => 'text',
			'std' => ''
		),
		
		array(
			'name' => 'Cat&eacute;gories',
			'desc' => '<strong>Left</strong> = A gauche - <strong>Right</strong> = A droite - <strong>None</strong> = Au centre.',
			'id' => $prefix . 'index_cat',
			'type' => 'select',
			'options' => $options_categories
		),
		
		array(
			'name' => 'Longeur des articles',
			'desc' => 'indiquez le nombre de caract&egrave;re',
			'id' => $prefix . 'lench_post_index',
			'type' => 'text',
			'std' => ''
		),
			)
);

add_action('admin_menu', 'page_add_box');

// Add meta box
function page_add_box() {
	global $meta_box_page_opts;
	
	add_meta_box($meta_box_page_opts['id'], $meta_box_page_opts['title'], 'page_opts_show_box', $meta_box_page_opts['page'], $meta_box_page_opts['context'], $meta_box_page_opts['priority']);
	
	
}

// Callback function to show fields in meta box
function page_opts_show_box() {
	global $meta_box_page_opts, $post;
	
	// Use nonce for verification
	echo '<input type="hidden" name="page_opts_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
	
	echo '<table class="form-table">';

	foreach ($meta_box_page_opts['fields'] as $field) {
		// get current post meta data
		$meta_opts = get_post_meta($post->ID, $field['id'], true);
		
		echo '<tr>',
				'<th style="width:20%"><label for="', $field['id'], '">', $field['name'], '</label></th>',
				'<td>';
		switch ($field['type']) {
		case 'description':
				echo $field['desc'];
				break;
			case 'text':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta_opts ? $meta_opts : $field['std'], '" size="10" style="width:10%" />',
					'<br />', $field['desc'];
				break;
			case 'textarea':
				echo '<textarea name="', $field['id'], '" id="', $field['id'], '" cols="60" rows="4" style="width:97%">', $meta_opts ? $meta_opts : $field['std'], '</textarea>',
					'<br />', $field['desc'];
				break;
			case 'select':
				echo '<select name="', $field['id'], '" id="', $field['id'], '" style="width:20%">';
				foreach ($field['options'] as $option) {
					echo '<option', $meta_opts == $option ? ' selected="selected"' : '', '>', $option, '</option>';
				}
				echo '</select>';
				break;
			case 'radio':
				foreach ($field['options'] as $option) {
					echo '<input type="radio" name="', $field['id'], '" value="', $option['value'], '"', $meta_opts == $option['value'] ? ' checked="checked"' :  '', ' />', $option['name'];
					
				}
				break;
				
			
			case 'checkbox':
				echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta_opts ? ' checked="checked"' : '', ' />';
				break;
		}
		echo 	'<td>',
			'</tr>';
	}
	
	echo '</table>';
	
}

add_action('save_post', 'page_opts_save_data');

// Save data from meta box
function page_opts_save_data($post_id) {
	global $meta_box_page_opts;
	
	// verify nonce
	if (!wp_verify_nonce($_POST['page_opts_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	}

	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ('page' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}
	
	foreach ($meta_box_page_opts['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}
}
?>