<?php
/*
Plugin Name: Sidebar tabs
Plugin URI: http://www.naxialis.com/
Description: Afficha d'un tableau jquery 
Author: fred
Version: 1
Author URI: http://www.naxialis.com/
*/
 
 
class SidebarTabsWidget extends WP_Widget
{
  function SidebarTabsWidget()
  {
    $widget_ops = array('classname' => 'SidebarTabsWidget', 'description' => 'Tableau Jquery' );
    $this->WP_Widget('SidebarTabsWidget', 'Tableau Jquery', $widget_ops);
  }
  
  function update($new_instance, $old_instance)
  {
    $instance = $old_instance;
    $instance['title'] = $new_instance['title'];
	$instance['recentposts'] = $new_instance['recentposts'];
	$instance['recentcomments'] = $new_instance['recentcomments'];
	$instance['popularpost'] = $new_instance['popularpost'];
	$instance['tagssmall'] = $new_instance['tagssmall'];
	$instance['tagsnum'] = $new_instance['tagsnum'];
	$instance['tagsbig'] = $new_instance['tagsbig'];
    return $instance;
  }
 
  function form($instance)
  {
    $instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
    $title = $instance['title'];
	$recentposts = $instance['recentposts'];
	$recentcomments = $instance['recentcomments'];
	$popularpost = $instance['popularpost'];
	$tagssmall = $instance['tagssmall'];
	$tagsnum = $instance['tagsnum'];
	$tagsbig = $instance['tagsbig'];
?>
  <p><label for="<?php echo $this->get_field_id('title'); ?>">Titre: <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo attribute_escape($title); ?>" /></label></p>
  
<p><label for="<?php echo $this->get_field_id('recentposts'); ?>">Nombre d&acute;article r&eacute;cent <input style="width:30px;" id="<?php echo $this->get_field_id('recentposts'); ?>" name="<?php echo $this->get_field_name('recentposts'); ?>" type="text" value="<?php echo attribute_escape($recentposts); ?>" /></label></p>

<p><label for="<?php echo $this->get_field_id('recentcomments'); ?>">Nombre de commentaire r&eacute;cent <input style="width:30px;" id="<?php echo $this->get_field_id('recentcomments'); ?>" name="<?php echo $this->get_field_name('recentcomments'); ?>" type="text" value="<?php echo attribute_escape($recentcomments); ?>" /></label></p>

<p><label for="<?php echo $this->get_field_id('popularpost'); ?>">Nombre d&acute;article populaire <input style="width:30px;" id="<?php echo $this->get_field_id('popularpost'); ?>" name="<?php echo $this->get_field_name('popularpost'); ?>" type="text" value="<?php echo attribute_escape($popularpost); ?>" /></label></p>

<p><strong>Nuage de mots cl&eacute;s</strong></p>
<p><label for="<?php echo $this->get_field_id('tagssmall'); ?>">Taille des petits mots : <input style="width:30px;" id="<?php echo $this->get_field_id('tagssmall'); ?>" name="<?php echo $this->get_field_name('tagssmall'); ?>" type="text" value="<?php echo attribute_escape($tagssmall); ?>" /></label></p>

<p><label for="<?php echo $this->get_field_id('tagsbig'); ?>">Taille des grand mots : <input style="width:30px;" id="<?php echo $this->get_field_id('tagsbig'); ?>" name="<?php echo $this->get_field_name('tagsbig'); ?>" type="text" value="<?php echo attribute_escape($tagsbig); ?>" /></label></p>

<p><label for="<?php echo $this->get_field_id('tagsnum'); ?>">Nombre de mots cl&eacute;s : <input style="width:30px;" id="<?php echo $this->get_field_id('tagsnum'); ?>" name="<?php echo $this->get_field_name('tagsnum'); ?>" type="text" value="<?php echo attribute_escape($tagsnum); ?>" /></label></p>
<?php
  }
 
  
 
  function widget( $args, $instance ) {
		extract( $args );
 
   
    $title = apply_filters('widget_title', $instance['title'] );
 	$recentposts = $instance['recentposts'];
	$recentcomments = $instance['recentcomments'];
	$popularpost = $instance['popularpost'];
	$tagssmall = $instance['tagssmall'];
	$tagsnum = $instance['tagsnum'];
	$tagsbig = $instance['tagsbig'];
    
	
	
	 echo $before_widget;
 	echo $before_title . $title . $after_title;
    // affichage du Widget
  ?>
 
<div class="container">
    		 <ul class="sd-tabs"> 
                <li><a href="#recentposts">R&eacute;cents</a></li>
                <li><a href="#core2">Commentaires</a></li>
                <li><a href="#jquerytuts2">Populaire</a></li>
                <li><a href="#tags"><dt>Mots-cl&eacute;s</a></li>
               
            </ul>
    		
    		<div class="tab_container">
    		
    			<ul id="recentposts" class="tab_content" >
    				
							<?php
	$the_query = new WP_Query('showposts='.$recentposts.'&orderby=post_date&order=desc');
	while ($the_query->have_posts()) : $the_query->the_post(); ?>
	<li>
  <div style="width:50px; height:65px;float:left; padding:5px ;"><?php global $post;
  $thumb=vp_get_thumb_url($post->post_content); 
  if ($thumb!='') echo '<img style="width:50px;" src="'.$thumb.'" alt="'. get_the_title().'" />';?>
  </div>
  									
 <p><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></p>
 <small class="tabs-meta">Le <?php the_time(__('j F Y')) ?> | </small></p> <dt class="comment-count-tabs"><?php comments_number( '0', '1', '%' ); ?></dt>
                                         
 <div class="clear"></div>
                                         
 </li>
 <div class="clear"></div>
												
<?php endwhile; ?>
<?php wp_reset_query(); ?>
			
    			</ul>
        		 
        		 <ul id="core2" class="tab_content">
                    <?php $comments = get_comments('status=approve&number='.$recentcomments.''); ?>

<?php foreach ($comments as $comment) { ?>
    <li class="recomm-wrapper"><?php
        $title = get_the_title($comment->comment_post_ID);
        echo get_avatar( $comment, '45' );
        echo '<span class="recommauth">' . ($comment->comment_author) . '</span>';
        ?> : "<?php
        echo wp_html_excerpt( $comment->comment_content, 80 ); ?>.."<br />
        <strong>Sur l'article :</strong>  <a href="<?php echo get_permalink($comment->comment_post_ID); ?>"
           rel="external nofollow" title="<?php echo $title; ?>">
           <?php echo $title; ?> </a>
    </li>
<?php }  ?> 
        		 </ul>
        		 
        		 <ul id="jquerytuts2" class="tab_content">
   <?php query_posts('orderby=comment_count&posts_per_page='.$popularpost.''); if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

<li>
<div style="width:50px; height:65px;float:left; padding:5px ;"><?php global $post;
  $thumb=vp_get_thumb_url($post->post_content); 
  if ($thumb!='') echo '<img style="width:50px;" src="'.$thumb.'" alt="'. get_the_title().'" />';?>
  </div>
<p><a title="<?php the_title(); ?>" href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></p> 
                                         <small class="tabs-meta">Le <?php the_time(__('j F Y')) ?> | </small><div class="comment-count-tabs"><?php comments_number( '0', '1', '%' ); ?></div>
                                         
                                      <div class="clear"></div>

</li>

<?php endwhile; ?>
<?php else : ?>
<p>D&eacute;sol&eacute;, aucun article n&acute;a &eacute;t&eacute; trouv&eacute;.</p>
<?php endif; ?>
<?php wp_reset_query(); ?>

    
        		 </ul>
                 
         
          <ul id="tags" class="tab_content">
       		
       <?php
$tag_args = array(
	'smallest'  => $tagssmall,
	'largest'   => $tagsbig,
	'unit'      => 'px',
	'number'    => $tagsnum,
	'format'    => 'flat',
	'order'     => 'RAND',
	'echo'      => true
);
echo '<div class="tags-widget">';
	wp_tag_cloud( $tag_args );
echo '</div>';
?>

<div class="clear"></div>
    
        		 </ul>
        		 
  
        		 
    		 </div> <!-- END List Wrap -->
		 </div>  <!-- END sd-tabs -->
		  <div class="clear"></div>
	

  
  <?php
 // fin affichage du widget
    echo $after_widget;
  }
 
}


// fin fonction

add_action( 'widgets_init', create_function('', 'return register_widget("SidebarTabsWidget");') );?>