<?php
/*
 * Plugin Name: Simplicy post view
 * Version: 1.2
 * Plugin URI: http://plugins.svn.wordpress.org/simplicy-post-view/
 * Description: afficher vos article avec miniature dans votre sidebar.
 * Author: Naxialis
 * Author URI: http://www.naxialis.com
 */
class Widget_Simplicy_Post extends WP_Widget  //class /!\
{
	function Widget_Simplicy_Post() 
	{		
		$widget_ops = array('classname' => 'Widget_Simplicy_Post', 'description' => __( "Afficher et personnaliser l&acute;affichage de vos articles dans la sidebar") );		
		$control_ops = array('width' => 350, 'height' => 300);		
		$this->WP_Widget('Widget_Simplicy_Post', __('Simplicy post view'), $widget_ops, $control_ops);
	}

	function widget($args, $instance){
		extract($args);    
		$title = apply_filters('widget_title', empty($instance['title']) ? '&nbsp;' : $instance['title']); 
		$item = empty($instance['item']) ? null : $instance['item']; 
		$nb_posts = empty($instance['posts_nb']) ? 5 : $instance['posts_nb'] ; 
		$thumb_w = empty($instance['thumb_w']) ? null : $instance['thumb_w']; 
		$thumb_h = empty($instance['thumb_h']) ? null : $instance['thumb_h']; 
		$lenght = empty($instance['lenght']) ? null : $instance['lenght'];
		 
		
		
		// Find dropdown value categorie
      if(strpos($item, 'p:') !== FALSE) {
        $post = str_replace('p:', '', $item);
      } else if(strpos($item, 'c:') !== FALSE) {
        $category = str_replace('c:', '', $item);
      }     
      if($category != 0) {
        $data = spp_get_post('category', $category);
        $data = $data[0];
      } else if($post != 0) {
        $data = spp_get_post('post', $post);
        $data = $data[0];
      } else {
        // If no post or category is selected, use the most recent post.
        $data = spp_get_post('post');
        $data = $data[0];
        if(!$data) {
          $title = "Simple Post view";
          $length = 100;
          $data = (object)array(
            'post_title' => 'Error!',
            'post_content' => 'This widget needs configuration',
          );
        }
    }
	
// fin categorie
		
		echo $before_widget;		
		if ( $title )
			echo $before_title . $title . $after_title;
						
	
		
	

	
		// affichage du widget
		echo "<ul class='SP-post'>" ;
		if ($item != null)
		{
			if (is_numeric($category))
			{
				query_posts('p='.$post.'&cat='.$category.'&showposts='.$nb_posts);
			}
			else
			{
				query_posts('p='.$post.'&category_name='.$category.'&showposts='.$nb_posts ) ;
			}
			if (have_posts())
			{
				
				while (have_posts()) : the_post() ;  ?>
                <div <?php post_class(); ?> id="post-<?php the_ID(); ?>">
					 <div class="simplicy-post-clear"></div>
						                    <!-- affichage de la miniature -->
                    <?php if ( $instance['view_thumbs'] ) : ?>
                    <a href="<?php the_permalink() ?>" >
						<?php global $post;
  						$thumb=vp_get_thumbs_url($post->post_content); 
  						if ($thumb!='') echo '<dt><img class="simplicy-post-img" width="'.$thumb_w.'" height="'.$thumb_h.'" src="'.$thumb.'" alt="'. get_the_title().'" /></dt>'; ?>
  					</a>
                    
                    <?php endif; ?>
                    <dt class="simplicy-post" ><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php printf(the_title()); ?>"><strong><?php the_title(); ?></strong></a></dt>
                    <!-- affichage de la miniature fin -->
                  <dt class="simplicy-date_post"> Le <?php the_time('j F, Y') ?>| <strong><?php comments_number('0','1 ','%' );?></strong> </dt><br />

                   
                     <?php echo "<div class='simplicy-post-content'></div>"; ?>
                     <?php echo "</div> "; ?>
				<?php endwhile ;
				wp_reset_query();
				// the excerpt		
				
				echo "</br> ";
				echo "</p>";
				echo "</ul>" ;
				
			}
		}
		
		echo $after_widget;
	}

	function update($new_instance, $old_instance)
	{
		//on enregistre la variable 'titre'
		$instance = $old_instance; 		
		$instance['title'] = strip_tags(stripslashes($new_instance['title']));
		//on enregistre la variable 'category'
		$instance['category'] = strip_tags(stripslashes($new_instance['category']));
		$instance['post_id'] = strip_tags(stripslashes($new_instance['post_id']));
		//on enregistre la variable 'posts'
		$instance['posts_nb'] = strip_tags(stripslashes($new_instance['posts_nb']));		
		$instance['thumb_w'] = strip_tags(stripslashes($new_instance['thumb_w']));		
		$instance['thumb_h'] = strip_tags(stripslashes($new_instance['thumb_h']));
		$instance['excerpt'] = strip_tags(stripslashes($new_instance['excerpt']));
		$instance['view_thumbs'] = strip_tags(stripslashes($new_instance['view_thumbs']));
		$instance['excerpt_length'] = strip_tags(stripslashes($new_instance['excerpt_length']));
		$instance['item'] = strip_tags(stripslashes($new_instance['item']));
		

		return $instance;

	
	$post = $post_old; // Restore the post object.
	}
	

	function form($instance) {
		//les valeurs par défaut sont définies ici, par exemple 'posts'=>'5' défini le nombre de posts à afficher à 5 par défaut
		$instance = wp_parse_args( (array) $instance, array('title'=>'', 'category'=>'', 'posts'=>'5') );
		

		//on stocke les valeurs, en s'assurant qu'ils vont s'afficher correctement
		$title = htmlspecialchars($instance['title']);
		$category = htmlspecialchars($instance['category']);
		$posts_nb = htmlspecialchars($instance['posts_nb']);
		$thumb_w = htmlspecialchars($instance['thumb_w']);
		$thumb_h = htmlspecialchars($instance['thumb_h']);
		$item = htmlspecialchars($instance['item']);
		$post = htmlspecialchars($instance['post_id']);
	
		
		

		echo '<p style="text-align:left;"><label for="' . $this->get_field_name('title') . '">' . __('<p>Titre:</p>') . ' <input style="width: 250px;float:left;" id="' . $this->get_field_id('title') . '" name="' . $this->get_field_name('title') . '" type="text" value="' . $title . '" /></label></p>'; ?>
        
		<?php //La catégorie ?>
<br /><br />           
     <p>
    <label for="<?php echo $this->get_field_name('item'); ?>"><?php echo __('Selectioner un article ou une catégorie:'); ?></label><br><br />
    <select name="<?php echo $this->get_field_name('item'); ?>" id="<?php echo $this->get_field_id('item'); ?>">
          <option value=""> Choisir un article ou une catégorie </option>
        <?php foreach(spp_get_dropdown() as $category) : ?>
          <option style="width: 225px;" <?php echo ('c:' . $category['category_id'] == $instance['item']) ? 'selected' : '' ?> value="c:<?php echo $category['category_id']; ?>">
          Catégorie: <?php echo $category['category_name']; ?>
          </option>

        <?php foreach($category['children'] as $post): ?>
          <option <?php echo ('p:' . $post['post_id'] == $instance['item']) ? 'selected' : '' ?> value="p:<?php echo $post['post_id']; ?>">
            Article- <?php echo $post['post_name']; ?>
          </option>
        <?php endforeach; ?>
      	<?php endforeach; ?>
    </select>
  </p>
  <?php
		//Le nombre de posts à montrer
		echo '<p style="text-align:left;"><label for="' . $this->get_field_name('posts_nb') . '">' . __('<p>Nombre d&acute;article à afficher:</p>') . ' <input style="width: 100px;float:left;" id="' . $this->get_field_id('posts') . '" name="' . $this->get_field_name('posts_nb') . '" type="text" value="' . $posts_nb . '" /></label></p><br /><br />'; ?>
	
	
        
<?php // afficher une vignette ?>    
<label for="<?php echo $this->get_field_id("view_thumbs"); ?>">
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id("view_thumbs"); ?>" name="<?php echo $this->get_field_name("view_thumbs"); ?>"<?php checked( (bool) $instance["view_thumbs"], true ); ?> />
				<?php _e( 'Afficher une vignette' ); ?>
			</label>
    	
		<?php //dimention de la vignette ?>
		<p>
			<label>
				<?php _e('<p>Dimenssion de la vignette: </p>'); ?>
				<?php echo '<p style="text-align:left;"><label for="' . $this->get_field_name('thumb_w') . '">' . __('<p style="float:left;line-height:22px;">Largeur :</p>') . '<input style="width:20%;float:left;" id="' . $this->get_field_id('thumb_w') . '" name="' . $this->get_field_name('thumb_w') . '" type="text" value="' . $thumb_w . '" /></label></p>'; ?>
				</label>
           		<label>				
				<?php echo '<p style="text-align:left;"><label for="' . $this->get_field_name('thumb_h') . '">' . __('<p style="float:left;line-height:22px;padding-left:10px;">Hauteur :</p>') . '<input style="width:20%;float:left;" id="' . $this->get_field_id('thumb_h') . '" name="' . $this->get_field_name('thumb_h') . '" type="text" value="' . $thumb_h . '" /></label></p>'; ?>
				</label>
			
		</p>
        <br /> <br />

<?php

	}
}


// ******************************************************** fonction image ***************************************************************
 

function vp_get_thumbs_url($text)
{
  global $post;
 
  $imageurl="";        
 
  // extract the thumbnail from attached imaged
  $allimages =&get_children('post_type=attachment&post_mime_type=image&post_parent=' . $post->ID );        
 
  foreach ($allimages as $img){                
     $img_src = wp_get_attachment_image_src($img->ID);
     break;                       
  }
 
  $imageurl=$img_src[0];
 
 
  // try to get any image
  if (!$imageurl)
  {
    preg_match('/<\s*img [^\>]*src\s*=\s*[\""\']?([^\""\'>]*)/i' ,  $text, $matches);
    $imageurl=$matches[1];
  }
 
  // try to get youtube video thumbnail
  if (!$imageurl)
  {
    preg_match("/([a-zA-Z0-9\-\_]+\.|)youtube\.com\/watch(\?v\=|\/v\/)([a-zA-Z0-9\-\_]{11})([^<\s]*)/", $text, $matches2);
 
    $youtubeurl = $matches2[0];
    if ($youtubeurl)
     $imageurl = "http://i.ytimg.com/vi/{$matches2[3]}/1.jpg"; 
   else preg_match("/([a-zA-Z0-9\-\_]+\.|)youtube\.com\/(v\/)([a-zA-Z0-9\-\_]{11})([^<\s]*)/", $text, $matches2);
 
   $youtubeurl = $matches2[0];
   if ($youtubeurl)
     $imageurl = "http://i.ytimg.com/vi/{$matches2[3]}/1.jpg"; 
  }
 
 
return $imageurl;
}



/**
 * Get all posts or all posts from a category
 */
function spp_get_all_posts($category = NULL) {
  global $wpdb;
  $query =
    "SELECT ID, post_title, post_content, post_date, post_status, guid, term_id
     FROM {$wpdb->posts}
     LEFT JOIN {$wpdb->term_relationships}
     ON object_id = ID
     LEFT JOIN {$wpdb->term_taxonomy}
     ON {$wpdb->term_relationships}.term_taxonomy_id = {$wpdb->term_taxonomy}.term_taxonomy_id
     WHERE post_status = 'publish'";
     if($category != NULL) {
       $query .= " AND {$wpdb->term_taxonomy}.term_id = " . $category;
     }
     $query .= " AND post_type = 'post'
     GROUP BY ID
     ORDER BY post_date
     ;";
  $data = $wpdb->get_results($query);
  
  return $data;
}



/**
 * Select a specific post or the latest post from a category
 */
function spp_get_post($type, $selector = NULL) {
  global $wpdb;
  if($selector == NULL) {
    $data = $wpdb->get_results(
      "SELECT ID, post_title, post_content, post_excerpt, post_date, post_status, guid
       FROM {$wpdb->posts}
       LEFT JOIN {$wpdb->term_relationships}
       ON object_id = ID
       WHERE ID = (SELECT max(ID) FROM {$wpdb->posts} WHERE post_type = 'post' AND post_status = 'publish')
       LIMIT 1;"
    );
  } else {
    switch($type) {
      case 'category':
        $data = $wpdb->get_results(
          "SELECT ID, post_title, post_content, post_excerpt, post_date, post_status, guid, term_id
           FROM {$wpdb->posts}
           LEFT JOIN {$wpdb->term_relationships}
           ON object_id = ID
           LEFT JOIN {$wpdb->term_taxonomy}
           ON {$wpdb->term_relationships}.term_taxonomy_id = {$wpdb->term_taxonomy}.term_taxonomy_id
           WHERE term_id = $selector
           AND post_status = 'publish'
           ORDER BY post_date
           DESC LIMIT 1;"
        );
        break;

      case 'post':
        $data = $wpdb->get_results(
          "SELECT ID, post_title, post_content, post_excerpt, post_date, post_status, guid
           FROM {$wpdb->posts}
           LEFT JOIN {$wpdb->term_relationships}
           ON object_id = ID
           WHERE ID = $selector
           AND post_status = 'publish'
           LIMIT 1;"
        );
        break;
    }
  }
  return $data;
}

/**
 * Get all categories
 */
function spp_get_categories() {
  global $wpdb;
  $categories = $wpdb->get_results(
    "SELECT {$wpdb->terms}.term_id, name FROM {$wpdb->terms}
     LEFT JOIN {$wpdb->term_taxonomy}
     ON {$wpdb->term_taxonomy}.term_id = {$wpdb->terms}.term_id
     WHERE {$wpdb->term_taxonomy}.taxonomy = 'category'
     AND {$wpdb->term_taxonomy}.count > 0;"
  );
  return $categories;
}

function spp_get_dropdown() {
  $categories = spp_get_categories();
  $i = 0;
  foreach($categories as $category) {
    $posts = spp_get_all_posts($category->term_id);
    $select[$i]['category_name'] = $category->name;
    $select[$i]['category_id'] = $category->term_id;
    $j = 0;
    foreach($posts as $post) {
      $select[$i]['children'][$j]['post_name'] = $post->post_title;
      $select[$i]['children'][$j]['post_id'] = $post->ID;
      $j++;
    }
    $i++;
  }
  return $select;
}

function affichageCategorieInit() //donnez un nom qui vous parle -pas de prérequis
{
    register_widget('Widget_Simplicy_Post'); //le nom de la classe
}
add_action('widgets_init', 'affichageCategorieInit'); //le nom de la fonction définit juste au dessus