<?php /* Template Name: Edit Posts */ 

$query = new WP_Query(array('post_type' => 'post', 'posts_per_page' =>'-1', 'post_status' => array('publish', 'pending', 'draft', 'private', 'trash') ) );

if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
	
	if(isset($_GET['post'])) {
		
		if($_GET['post'] == $post->ID)
		{
			$current_post = $post->ID;

			$title = get_the_title();
			$content = get_the_content();
			$winerating = get_post_meta($current_post, 'rating', true);
			$tags_annonce = get_post_meta($current_post, 'post_tags', true);
		 	$image_id = get_post_thumbnail_id();
			$image_url = wp_get_attachment_image_src($image_id,'large', true);
		}
	}

endwhile; endif;
wp_reset_query();

global $current_post;

$postTitleError = '';

if(isset($_POST['submitted']) && isset($_POST['post_nonce_field']) && wp_verify_nonce($_POST['post_nonce_field'], 'post_nonce')) {

	if(trim($_POST['postTitle']) === '') {
		$postTitleError = 'Please enter a title.';
		$hasError = true;
	} else {
		$postTitle = trim($_POST['postTitle']);
	}

	

	$post_information = array(
		'ID' => $current_post,
		'post_title' => esc_attr(strip_tags($_POST['postTitle'])),
		'post_content' => esc_attr(strip_tags($_POST['postContent'])),
		'post_category'	=>	array($_POST['cat'],70),
		'tags_input'	=>	array($tags),
		'post-type' => 'post',
		'winerating'	=>	$winerating,
		'post_status' => 'pending'
	);

	$post_id = wp_update_post($post_information);

	if($post_id)
	{
		//ADD OUR CUSTOM FIELDS
		wp_set_post_tags($post_id,esc_attr(strip_tags($_POST['post_tags'])));
		update_post_meta($post_id, 'rating', esc_attr(strip_tags($_POST['winerating'])));
		
		if ($_FILES) {
		foreach ($_FILES as $file => $array) {
		$newupload = insert_attachment($file,$post_id);
		// $newupload returns the attachment id of the file that
		// was just uploaded. Do whatever you want with that now.
		}

	} // END THE IF STATEMENT FOR FILES
		
		wp_redirect('http://laprevention.be/view-annonces/');
		die();
	}

}



$cat_press_free = get_option('press_category_free') ;
$args_cat = array(
        'tab_index' => '10',
        'taxonomy' => 'category',
        'hide_empty' => 0,
        'include' => $cat_press_free
    );

?>

<?php get_header(); ?>

	<!-- #primary BEGIN -->
	<div id="content-no-sidebar">
<div class="wpcf7">
		<form action="" id="primaryPostForm" method="POST">

			<fieldset>

				<label for="postTitle"><?php _e('Titre de l&acute;annonce:', 'framework') ?></label>

				<input type="text" name="postTitle" id="postTitle" value="<?php echo $title; ?>" size="100" class="required" />

			</fieldset>

			<?php if($postTitleError != '') { ?>
				<span class="error"><?php echo $postTitleError; ?></span>
				<div class="clearfix"></div>
			<?php } ?>

			<fieldset>
						
				<label for="postContent"><?php _e('Texte de l&acute;annonce:', 'framework') ?></label>

				<textarea name="postContent" id="postContent" cols="100" rows="20"><?php echo $content; ?></textarea>

			</fieldset>
            
            <fieldset class="category">
				<label for="cat">Cat&eacute;gorie:</label>
                <div class="category-front">
				<?php wp_dropdown_categories($args_cat); ?>
                </div>
			</fieldset>
            
            
            <!-- contact-->
			<fieldset class="winerating">
				<label for="winerating">Adresse email ou t&eacute;l pour être contact&eacute; : </label>
				<input type="text" value="<?php echo $winerating; ?>" id="winerating" tabindex="20" name="winerating" />
                <div class="clear"></div>	
              <small><em>(les coordonn&eacute;es de contact seront uniquement visible pour les membres de la pr&eacute;vention)</em></small><br /><br />
			</fieldset>
            
            <?php // echo $image_url[0];  ?>
            
            <!-- post tags -->
			<fieldset class="tags">
				<label for="post_tags">Mots cl&eacute;s <em>(s&eacute;par&eacute;s une virgules)</em>:</label>
				<input type="text" value="<?php echo $tags_annonce; ?>" tabindex="35" name="post_tags" id="post_tags" />
			</fieldset>
            
            <div class="tag-annonces">
            <h5><strong>Mot(s) disponible:</strong></h5>
            <ul>
    <?php
        query_posts('category_name=annonces');
        if (have_posts()) : while (have_posts()) : the_post();
           if( get_the_tag_list() ){
              echo get_the_tag_list('<li>','</li><li>','</li>');
           }
        endwhile; endif; 
        wp_reset_query(); 
    ?>
</ul>
            
            </div>

			<fieldset>
				
				<?php wp_nonce_field('post_nonce', 'post_nonce_field'); ?>
<fieldset class="submit">
				<input type="hidden" name="submitted" id="submitted" value="true" />
				<button class="submit-post" type="submit"><?php _e('Mettre à jour', 'framework') ?></button>
</fieldset>
			</fieldset>

		</form>

</div>
	</div><!-- #primary END -->


<?php get_footer(); ?>