<?php
/**
 * Plugin Name: Widget inscription
 * Plugin URI: 
 * Description: 
 * Version: 0.1
 * Author: naxialis
 * Author URI: 
 *
 */

/**
 * Add function to widgets_init that'll load our widget.
 * @since 0.1
 */
add_action( 'widgets_init', 'incription_load_widgets' );

/**
 * Register our widget.
 * 'prevention_Widget' is the widget class used below.
 *
 * @since 0.1
 */
function incription_load_widgets() {
	register_widget( 'prevention_Widget' );
}

/**
 * Example Widget class.
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 * @since 0.1
 */
class prevention_Widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function prevention_Widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'inscription_prevention', 'description' => __('Affiche le bouton inscription.', 'inscription_prevention') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'prevention-widget' );

		/* Create the widget. */
		$this->WP_Widget( 'prevention-widget', __('Inscription la prevention', 'inscription_prevention'), $widget_ops, $control_ops );
	}

	/**
	 * How to display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$texte = $instance['texte'];
		
		

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $title )
			echo $before_title . $title . $after_title;

		/* Display name from widget settings if one was input. */
		?>
        <ul id="sign-prevention">
        <p> <?php echo $texte;?></p>
        <div class="contrainer-sub"><a class="subcribe-prv subcribe-prv-active" href="<?php echo site_option('url_inscription');?>"><i class="fa fa-user"></i> Inscrivez-vous </a> <a class="infos-btn" href="<?php echo site_option('info_url');?>"><i class="fa fa-info-circle"></i></a></div>
 
  <div class="clear-fix"></div>
</ul>
        <?php
		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['texte'] = strip_tags( $new_instance['texte'] );
	

		return $instance;
	}

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array( 'title' => __('S&acute;inscrire sur la pr&eacute;vention.be', 'inscription_prevention') );
		$instance = wp_parse_args( (array) $instance, $defaults ); 
		$texte = esc_textarea($instance['texte'] );?>
		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Titre du widget:', 'hybrid'); ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" style="width:100%;" />
            
		</p>
        <p>
        <label for="<?php echo esc_attr( $this->get_field_id('texte') ); ?>"><?php _e('texte:', ''); ?></label>
		<textarea id="<?php echo esc_attr( $this->get_field_id('texte') ); ?>" name="<?php echo esc_attr( $this->get_field_name('texte') ); ?>" class="widefat" style="width:100%;"><?php echo esc_html( $texte ); ?></textarea>
        </p>


	<?php
	}
}

?>